/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.io.FileUtil;
import com.jfoenix.controls.JFXMasonryPane;
import com.jfoenix.controls.JFXNodesList;
import com.jfoenix.controls.JFXTabPane;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.appication.SceneNavigateBundle;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.Choosers;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.db.dao.BookDao;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.BookBundle;
import com.unclezs.novel.app.main.model.BookCache;
import com.unclezs.novel.app.main.model.config.BookShelfConfig;
import com.unclezs.novel.app.main.util.BookHelper;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.BookNode;
import com.unclezs.novel.app.main.views.components.cell.TocListCell;
import com.unclezs.novel.app.main.views.home.AnalysisView;
import com.unclezs.novel.app.main.views.home.HomeView;
import com.unclezs.novel.app.main.views.home.ImportBookView;
import com.unclezs.novel.app.main.views.reader.ReaderView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/fiction-bookshelf.fxml")
public class FictionBookshelfView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(FictionBookshelfView.class);
    public static final String BUNDLE_BOOK_KEY = "bundle-book-key";
    public static final String GROUP_ALL = "\u5168\u90e8";
    public static final String GROUP_LOCAL = "\u672c\u5730";
    public static final String CACHE_FOLDER_NAME = "book";
    public static final File CACHE_FOLDER = ResourceManager.cacheFile("book");
    private static final String PAGE_NAME = "\u5c0f\u8bf4\u4e66\u67b6";
    private final ObservableList<BookNode> bookNodes = FXCollections.observableArrayList();
    private final BookDao bookDao = new BookDao();
    private final ObservableSet<String> groups = FXCollections.observableSet((Object[])new String[0]);
    @FXML
    private JFXNodesList floatButtons;
    @FXML
    private JFXTabPane groupPanel;
    @FXML
    private JFXMasonryPane bookPanel;
    @FXML
    private ContextMenu bookNodeContextMenu;
    @FXML
    private ContextMenu groupTabContextMenu;
    private BookShelfConfig bookShelfConfig;

    public void onCreated() {
        this.bookShelfConfig = SettingManager.manager().getBookShelf();
        String selectedGroup = this.bookShelfConfig.getGroup();
        this.groups.addListener(change -> {
            if (change.wasAdded()) {
                this.addGroup((String)change.getElementAdded());
            }
            if (change.wasRemoved()) {
                this.deleteGroup((String)change.getElementRemoved());
            }
        });
        this.groups.add((Object)GROUP_ALL);
        this.bookDao.selectAll().forEach(book -> {
            this.addBook((Book)book);
            if (book.getGroup() != null) {
                this.groups.add((Object)book.getGroup());
            }
        });
        this.bookNodes.addListener(c -> {
            while (c.next()) {
                c.getRemoved().forEach(bookNode -> {
                    this.bookPanel.getChildren().remove((Object)bookNode);
                    this.bookDao.delete(bookNode.getBook());
                });
                c.getAddedSubList().forEach(bookNode -> {
                    this.bookDao.save(bookNode.getBook());
                    String currentGroup = this.groupPanel.getTabs().stream().filter(Tab::isSelected).map(Tab::getText).findFirst().orElse(null);
                    if (bookNode.getBook().getGroup() != null) {
                        this.groups.add((Object)bookNode.getBook().getGroup());
                    }
                    if (Objects.equals(currentGroup, GROUP_ALL) || Objects.equals(currentGroup, bookNode.getBook().getGroup())) {
                        this.bookPanel.getChildren().add((Object)bookNode);
                    }
                });
            }
            this.bookPanel.requestLayout();
        });
        if (GROUP_ALL.equals(selectedGroup)) {
            this.bookPanel.getChildren().setAll(this.bookNodes);
        } else {
            this.groupPanel.getTabs().stream().filter(tab -> tab.getText().equals(selectedGroup)).findFirst().ifPresent(tab -> this.groupPanel.getSelectionModel().select(tab));
        }
        if (Boolean.TRUE.equals(this.bookShelfConfig.getAutoUpdate().get())) {
            this.checkUpdateGroup();
        }
        this.listenerTitleVisible();
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        BookBundle bookBundle = (BookBundle)bundle.get(BUNDLE_BOOK_KEY);
        if (bookBundle != null) {
            Book book = Book.fromBookBundle(bookBundle);
            BookHelper.downloadCover(book.getCover(), book.getUrl(), FileUtil.file((File)CACHE_FOLDER, (String)book.getId()), cover -> {
                book.setCover((String)cover);
                this.bookDao.update(book);
            });
            this.cacheBook(book);
            this.addBook(book);
        }
    }

    @FXML
    public void importBook() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("\u6587\u672c\u6587\u4ef6", new String[]{"*.txt"});
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{filter});
        File file = fileChooser.showOpenDialog((Window)App.stage());
        if (file == null) {
            return;
        }
        SidebarNavigateBundle bundle = new SidebarNavigateBundle();
        bundle.put("bundle-file-key", (Object)file);
        this.navigation.navigate(ImportBookView.class, bundle);
    }

    public void addBook(Book book) {
        BookNode bookNode = new BookNode(book);
        bookNode.setOnContextMenuRequested(e -> {
            this.bookNodeContextMenu.show((Node)bookNode, e.getScreenX(), e.getScreenY());
            e.consume();
        });
        EventUtils.setOnMousePrimaryClick((Node)bookNode, e -> this.readBook(bookNode));
        this.bookNodes.add((Object)bookNode);
    }

    public void addOrUpdateBook(Book book) {
        this.bookNodes.stream().filter(bookNode -> Objects.equals(bookNode.getBook().getId(), book.getId())).findFirst().ifPresent(arg_0 -> this.bookNodes.remove(arg_0));
        this.addBook(book);
    }

    public void readBook(BookNode bookNode) {
        Book book = bookNode.getBook();
        if (book.isLocal() && !FileUtil.exist((String)book.getUrl())) {
            Toast.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        if (book.isUpdate()) {
            bookNode.setUpdate(false);
            this.bookDao.update(book);
        }
        SceneNavigateBundle bundle = new SceneNavigateBundle();
        bundle.put("read-book-key", (Object)book);
        ((HomeView)((Object)AppContext.getView(HomeView.class))).getApp().navigate(ReaderView.class, bundle);
    }

    @FXML
    private void readBook() {
        this.readBook((BookNode)this.bookNodeContextMenu.getOwnerNode());
    }

    @FXML
    private void addDownload() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        Book book = node.getBook();
        if (book.isLocal()) {
            Toast.error((String)"\u672c\u5730\u5c0f\u8bf4\u65e0\u9700\u4e0b\u8f7d");
            return;
        }
        BookCache cache = BookHelper.loadCache(FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
        BookHelper.submitDownload(book.toNovel(), cache.getRule(), cache.getToc());
    }

    @FXML
    private void analysisDownload() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        Book book = node.getBook();
        if (book.isLocal()) {
            Toast.error((String)"\u672c\u5730\u5c0f\u8bf4\u65e0\u9700\u4e0b\u8f7d");
            return;
        }
        SidebarNavigateBundle bundle = (SidebarNavigateBundle)new SidebarNavigateBundle().put("novel-info", (Object)book.toNovel());
        ((AnalysisView)((Object)AppContext.getView(AnalysisView.class))).getNavigation().navigate(AnalysisView.class, bundle);
    }

    @FXML
    private void renameBook() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        String initName = node.getBook().getName();
        ModalBox.input((String)initName, (String)"\u8bf7\u8f93\u5165\u65b0\u7684\u5c0f\u8bf4\u540d\u79f0", newName -> {
            node.setTitle((String)newName);
            this.bookDao.update(node.getBook());
            Toast.success((String)"\u4fee\u6539\u6210\u529f");
        }).title("\u91cd\u547d\u540d\u5c0f\u8bf4").show();
    }

    @FXML
    private void changeCover() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        File file = Choosers.chooseImage((String)"\u5c0f\u8bf4\u5c01\u9762");
        if (file != null) {
            Book book = node.getBook();
            File cover = FileUtil.copy((File)file, (File)FileUtil.file((File)CACHE_FOLDER, (String[])new String[]{book.getId(), "cover.jpeg"}), (boolean)true);
            node.setCover(cover.getAbsolutePath());
            this.bookDao.update(book);
        }
    }

    @FXML
    public void searchCover() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        Book book = node.getBook();
        String name = book.getName();
        TaskFactory.create(() -> {
            String cover = SpiderHelper.getCover((String)name);
            log.trace("\u83b7\u53d6\u5230\u300a{}\u300b\u5c0f\u8bf4\u5c01\u9762\uff1a{}", (Object)cover, (Object)name);
            cover = BookHelper.downloadCover(cover, null, FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
            return cover;
        }).onSuccess(cover -> {
            node.setCover((String)cover);
            this.bookDao.update(book);
            Toast.success((String)"\u5c01\u9762\u83b7\u53d6\u6210\u529f");
        }).onFailed(e -> {
            log.error("\u5c01\u9762\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)book.getName(), e);
            Toast.error((String)"\u5c01\u9762\u83b7\u53d6\u5931\u8d25");
        }).start();
    }

    private void listenerTitleVisible() {
        this.bookShelfConfig.getAlwaysShowBookTitle().addListener(e -> this.bookNodes.forEach(node -> node.showTitle((Boolean)this.bookShelfConfig.getAlwaysShowBookTitle().get())));
    }

    @FXML
    private void checkUpdate() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        if (node.getBook().isLocal()) {
            Toast.warn((String)"\u672c\u5730\u4e66\u7c4d\u65e0\u9700\u66f4\u65b0");
            return;
        }
        TaskFactory.create(() -> this.checkUpdateGroup(node)).onSuccess(news -> {
            if (news.isEmpty()) {
                Toast.success((String)"\u6682\u65e0\u66f4\u65b0");
            } else {
                ListView view = new ListView();
                view.setCellFactory(param -> new TocListCell());
                view.getItems().setAll((Collection)news);
                view.setMaxHeight(200.0);
                ModalBox.none().body((Node)view).title("\u53d1\u73b0\u65b0\u7ae0\u8282").show();
            }
        }).onFailed(e -> {
            Toast.error((String)"\u83b7\u53d6\u66f4\u65b0\u5931\u8d25");
            log.error("\u83b7\u53d6\u4e66\u7c4d\u66f4\u65b0\u5931\u8d25\uff1a{}", (Object)node.getBook().getName(), e);
        }).start();
    }

    @FXML
    private void checkUpdateGroup() {
        this.floatButtons.animateList(false);
        for (Node node : this.bookPanel.getChildren()) {
            BookNode bookNode;
            if (!(node instanceof BookNode) || (bookNode = (BookNode)node).getBook().isLocal()) continue;
            bookNode.setUpdateTaskState(true);
            TaskFactory.create((boolean)false, () -> this.checkUpdateGroup(bookNode)).onFinally(() -> bookNode.setUpdateTaskState(false)).start();
        }
    }

    private List<Chapter> checkUpdateGroup(BookNode bookNode) throws IOException {
        Book book = bookNode.getBook();
        if (book.isLocal()) {
            return Collections.emptyList();
        }
        File cacheFile = FileUtil.file((File)CACHE_FOLDER, (String)book.getId());
        BookCache cache = BookHelper.loadCache(cacheFile);
        NovelSpider novelSpider = new NovelSpider(cache.getRule());
        List toc = novelSpider.toc(book.getUrl());
        if (cache.getToc().size() == toc.size()) {
            return Collections.emptyList();
        }
        Set olds = cache.getToc().stream().map(Chapter::getUrl).collect(Collectors.toSet());
        ArrayList<Chapter> newChapters = new ArrayList<Chapter>();
        for (Chapter chapter : toc) {
            if (olds.contains(chapter.getUrl())) continue;
            newChapters.add(chapter);
        }
        cache.getToc().addAll(newChapters);
        BookHelper.cache(cache, cacheFile);
        Executor.runFx(() -> bookNode.setUpdate(true));
        this.bookDao.update(book);
        return newChapters;
    }

    private void cacheBook(Book book) {
        BookHelper.cache(new BookCache(book.getRule(), book.getToc()), FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
    }

    @FXML
    public void deleteBook() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        Book book = node.getBook();
        FileUtil.del((File)FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
        if (book.isLocal() && FileUtil.exist((String)book.getUrl())) {
            ModalBox.confirm(delete -> {
                if (Boolean.TRUE.equals(delete)) {
                    FileUtil.del((String)book.getUrl());
                }
            }).message("\u662f\u5426\u5220\u9664\u672c\u5730\u5c0f\u8bf4\u6587\u4ef6").cancel("\u4e0d\u4e86").submit("\u5220\u9664").showAndWait();
        }
        this.bookNodes.remove((Object)node);
    }

    private void addGroup(String name) {
        if (name == null) {
            return;
        }
        Tab tab = new Tab(name);
        tab.setOnSelectionChanged(e -> {
            if (tab.isSelected()) {
                if (GROUP_ALL.equals(name)) {
                    this.bookPanel.getChildren().setAll(this.bookNodes);
                } else {
                    List nodes = this.bookNodes.stream().filter(bookNode -> name.equals(bookNode.getBook().getGroup())).collect(Collectors.toList());
                    this.bookPanel.getChildren().setAll(nodes);
                }
                tab.setContent((Node)this.bookPanel);
                this.bookShelfConfig.setGroup(name);
            } else {
                tab.setContent(null);
            }
        });
        if (!GROUP_ALL.equals(name)) {
            tab.setContextMenu(this.groupTabContextMenu);
        } else {
            tab.setContent((Node)this.bookPanel);
        }
        this.groupPanel.getTabs().add((Object)tab);
    }

    @FXML
    private void setGroup() {
        BookNode node = (BookNode)this.bookNodeContextMenu.getOwnerNode();
        Book book = node.getBook();
        ComboBox groupSelector = new ComboBox();
        groupSelector.setMaxWidth(Double.MAX_VALUE);
        groupSelector.setEditable(true);
        groupSelector.setValue((Object)book.getGroup());
        groupSelector.getItems().addAll(this.groups);
        ModalBox.confirm(save -> {
            if (Boolean.TRUE.equals(save)) {
                String group = (String)groupSelector.getValue();
                if (StringUtils.isNotBlank((CharSequence)group)) {
                    this.groups.add((Object)group);
                } else {
                    group = null;
                }
                if (!Objects.equals(book.getName(), group) && book.getGroup() != null) {
                    this.bookPanel.getChildren().remove((Object)node);
                }
                node.getBook().setGroup(group);
                this.bookDao.update(book);
            }
        }).title("\u8bbe\u7f6e\u5206\u7ec4").body((Node)groupSelector).show();
    }

    @FXML
    private void deleteGroup() {
        String group = ((Label)this.groupTabContextMenu.getOwnerNode()).getText();
        this.groups.remove((Object)group);
    }

    private void deleteGroup(String group) {
        if (group == null) {
            return;
        }
        this.bookNodes.forEach(bookNode -> {
            if (group.equals(bookNode.getBook().getGroup())) {
                bookNode.getBook().setGroup(null);
            }
        });
        this.groupPanel.getTabs().removeIf(tab -> group.equals(tab.getText()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FictionBookshelfView)) {
            return false;
        }
        FictionBookshelfView other = (FictionBookshelfView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObservableList<BookNode> this$bookNodes = this.bookNodes;
        ObservableList<BookNode> other$bookNodes = other.bookNodes;
        if (this$bookNodes == null ? other$bookNodes != null : !this$bookNodes.equals(other$bookNodes)) {
            return false;
        }
        BookDao this$bookDao = this.bookDao;
        BookDao other$bookDao = other.bookDao;
        if (this$bookDao == null ? other$bookDao != null : !this$bookDao.equals(other$bookDao)) {
            return false;
        }
        ObservableSet<String> this$groups = this.groups;
        ObservableSet<String> other$groups = other.groups;
        if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) {
            return false;
        }
        JFXNodesList this$floatButtons = this.floatButtons;
        JFXNodesList other$floatButtons = other.floatButtons;
        if (this$floatButtons == null ? other$floatButtons != null : !this$floatButtons.equals(other$floatButtons)) {
            return false;
        }
        JFXTabPane this$groupPanel = this.groupPanel;
        JFXTabPane other$groupPanel = other.groupPanel;
        if (this$groupPanel == null ? other$groupPanel != null : !this$groupPanel.equals(other$groupPanel)) {
            return false;
        }
        JFXMasonryPane this$bookPanel = this.bookPanel;
        JFXMasonryPane other$bookPanel = other.bookPanel;
        if (this$bookPanel == null ? other$bookPanel != null : !this$bookPanel.equals(other$bookPanel)) {
            return false;
        }
        ContextMenu this$bookNodeContextMenu = this.bookNodeContextMenu;
        ContextMenu other$bookNodeContextMenu = other.bookNodeContextMenu;
        if (this$bookNodeContextMenu == null ? other$bookNodeContextMenu != null : !this$bookNodeContextMenu.equals(other$bookNodeContextMenu)) {
            return false;
        }
        ContextMenu this$groupTabContextMenu = this.groupTabContextMenu;
        ContextMenu other$groupTabContextMenu = other.groupTabContextMenu;
        if (this$groupTabContextMenu == null ? other$groupTabContextMenu != null : !this$groupTabContextMenu.equals(other$groupTabContextMenu)) {
            return false;
        }
        BookShelfConfig this$bookShelfConfig = this.bookShelfConfig;
        BookShelfConfig other$bookShelfConfig = other.bookShelfConfig;
        return !(this$bookShelfConfig == null ? other$bookShelfConfig != null : !((Object)this$bookShelfConfig).equals(other$bookShelfConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FictionBookshelfView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ObservableList<BookNode> $bookNodes = this.bookNodes;
        result = result * 59 + ($bookNodes == null ? 43 : $bookNodes.hashCode());
        BookDao $bookDao = this.bookDao;
        result = result * 59 + ($bookDao == null ? 43 : $bookDao.hashCode());
        ObservableSet<String> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : $groups.hashCode());
        JFXNodesList $floatButtons = this.floatButtons;
        result = result * 59 + ($floatButtons == null ? 43 : $floatButtons.hashCode());
        JFXTabPane $groupPanel = this.groupPanel;
        result = result * 59 + ($groupPanel == null ? 43 : $groupPanel.hashCode());
        JFXMasonryPane $bookPanel = this.bookPanel;
        result = result * 59 + ($bookPanel == null ? 43 : $bookPanel.hashCode());
        ContextMenu $bookNodeContextMenu = this.bookNodeContextMenu;
        result = result * 59 + ($bookNodeContextMenu == null ? 43 : $bookNodeContextMenu.hashCode());
        ContextMenu $groupTabContextMenu = this.groupTabContextMenu;
        result = result * 59 + ($groupTabContextMenu == null ? 43 : $groupTabContextMenu.hashCode());
        BookShelfConfig $bookShelfConfig = this.bookShelfConfig;
        result = result * 59 + ($bookShelfConfig == null ? 43 : ((Object)$bookShelfConfig).hashCode());
        return result;
    }
}

