/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.spider.Spider;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.PlaceHolder;
import com.unclezs.novel.app.framework.components.TabButton;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.serialize.PropertyJsonSerializer;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.core.spider.SpiderWrapper;
import com.unclezs.novel.app.main.db.beans.DownloadHistory;
import com.unclezs.novel.app.main.db.dao.DownloadHistoryDao;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.BookBundle;
import com.unclezs.novel.app.main.model.config.DownloadConfig;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.cell.DownloadActionTableCell;
import com.unclezs.novel.app.main.views.components.cell.DownloadHistoryActionTableCell;
import com.unclezs.novel.app.main.views.components.cell.ProgressBarTableCell;
import com.unclezs.novel.app.main.views.components.cell.TagsTableCell;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/download-manager.fxml")
public class DownloadManagerView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(DownloadManagerView.class);
    public static final String BUNDLE_DOWNLOAD_KEY = "bundle_download_key";
    public static final File TMP_DIR = ResourceManager.cacheFile("downloads");
    private static final String PAGE_NAME = "\u4e0b\u8f7d\u7ba1\u7406";
    private final DownloadHistoryDao historyDao = new DownloadHistoryDao();
    @FXML
    private TabButton tasksTab;
    @FXML
    private TabButton historyTab;
    @FXML
    private VBox tasksPanel;
    private VBox historyPanel;
    @FXML
    private TableView<SpiderWrapper> tasksTable;
    private TableView<DownloadHistory> historyTable;
    @FXML
    private StackPane container;

    public void onCreated() {
        this.createTasksTableColumns();
        this.restore();
        this.tasksTable.getItems().addListener(observable -> this.runTask());
        SettingManager.manager().getDownload().getTaskNum().addListener(e -> this.runTask());
        this.historyTab.setOnAction(e -> this.container.getChildren().setAll((Object[])new Node[]{this.getHistoryPanel()}));
        this.tasksTab.setOnAction(e -> this.container.getChildren().setAll((Object[])new Node[]{this.tasksPanel}));
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        BookBundle bookBundle = (BookBundle)bundle.get(BUNDLE_DOWNLOAD_KEY);
        if (bookBundle != null) {
            this.tasksTab.fireEvent((Event)new ActionEvent());
            this.createTask(bookBundle);
        }
    }

    public void onDestroy() {
        if (this.tasksTable.getItems().isEmpty()) {
            FileUtil.del((File)TMP_DIR);
        }
    }

    private Node getHistoryPanel() {
        if (this.historyPanel == null) {
            this.historyPanel = new VBox(new Node[]{this.getHistoryTable()});
        }
        return this.historyPanel;
    }

    private TableView<DownloadHistory> getHistoryTable() {
        if (this.historyTable == null) {
            this.historyTable = new TableView();
            this.historyTable.setPlaceholder((Node)new PlaceHolder(this.localized("download.manager.history.placeholder")));
            VBox.setVgrow(this.historyTable, (Priority)Priority.ALWAYS);
            this.historyTable.getItems().setAll(this.historyDao.selectAll());
            this.historyTable.getItems().addListener(c -> {
                while (c.next()) {
                    c.getRemoved().forEach(this.historyDao::delete);
                    c.getAddedSubList().forEach(this.historyDao::save);
                }
            });
            TableColumn id = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn("#"), (String[])new String[]{"id"});
            id.prefWidthProperty().bind((ObservableValue)this.historyTable.widthProperty().multiply(0.1));
            id.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)(this.historyTable.getItems().indexOf(param.getValue()) + 1)));
            TableColumn name = new TableColumn(this.localized("download.manager.history.name"));
            name.prefWidthProperty().bind((ObservableValue)this.historyTable.widthProperty().multiply(0.3));
            name.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((DownloadHistory)param.getValue()).getName()));
            TableColumn type = new TableColumn(this.localized("download.manager.history.type"));
            type.prefWidthProperty().bind((ObservableValue)this.historyTable.widthProperty().multiply(0.25));
            type.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((DownloadHistory)param.getValue()).getType()));
            type.setCellFactory(param -> new TagsTableCell());
            TableColumn date = new TableColumn(this.localized("download.manager.history.date"));
            date.prefWidthProperty().bind((ObservableValue)this.historyTable.widthProperty().multiply(0.2));
            date.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((DownloadHistory)param.getValue()).getDate()));
            TableColumn operation = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("download.manager.history.operation")), (String[])new String[]{"align-center"});
            operation.prefWidthProperty().bind((ObservableValue)this.historyTable.widthProperty().multiply(0.1));
            operation.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((DownloadHistory)col.getValue())));
            operation.setCellFactory(param -> new DownloadHistoryActionTableCell());
            this.historyTable.getColumns().addAll((Object[])new TableColumn[]{id, name, type, date, operation});
            this.historyTable.getColumns().forEach(column -> column.setResizable(false));
            ContextMenu contextMenu = new ContextMenu();
            MenuItem clearHistory = new MenuItem("\u6e05\u7a7a\u4e0b\u8f7d\u5386\u53f2", (Node)new Icon((Object)IconFont.DELETE));
            clearHistory.setOnAction(e -> this.historyTable.getItems().clear());
            contextMenu.getItems().add((Object)clearHistory);
            this.historyTable.setContextMenu(contextMenu);
        }
        return this.historyTable;
    }

    private void createTasksTableColumns() {
        TableColumn id = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn("#"), (String[])new String[]{"id"});
        id.prefWidthProperty().bind((ObservableValue)this.tasksTable.widthProperty().multiply(0.1));
        id.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)(this.tasksTable.getItems().indexOf(param.getValue()) + 1)));
        TableColumn name = new TableColumn(this.localized("download.manager.running.name"));
        name.prefWidthProperty().bind((ObservableValue)this.tasksTable.widthProperty().multiply(0.35));
        name.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((SpiderWrapper)param.getValue()).getName()));
        TableColumn progress = new TableColumn(this.localized("download.manager.running.progress"));
        progress.prefWidthProperty().bind((ObservableValue)this.tasksTable.widthProperty().multiply(0.35));
        progress.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((SpiderWrapper)param.getValue())));
        progress.setCellFactory(param -> new ProgressBarTableCell());
        TableColumn operation = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("download.manager.running.operation")), (String[])new String[]{"download-action-col"});
        operation.prefWidthProperty().bind((ObservableValue)this.tasksTable.widthProperty().multiply(0.15));
        operation.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((SpiderWrapper)col.getValue())));
        operation.setCellFactory(param -> new DownloadActionTableCell());
        this.tasksTable.getColumns().addAll((Object[])new TableColumn[]{id, name, progress, operation});
        this.tasksTable.getColumns().forEach(column -> column.setResizable(false));
    }

    public void onCompleted(SpiderWrapper wrapper) {
        FileUtil.del((File)FileUtil.file((File)TMP_DIR, (String)wrapper.getId()));
        this.tasksTable.getItems().remove((Object)wrapper);
        DownloadHistory downloadHistory = DownloadHistory.fromWrapper(wrapper);
        if (this.historyTable != null) {
            this.historyTable.getItems().add((Object)downloadHistory);
        } else {
            this.historyDao.save(downloadHistory);
        }
    }

    public void runTask() {
        block3: {
            int canRunTasksNumber;
            block2: {
                canRunTasksNumber = this.canRunTasksNumber();
                if (canRunTasksNumber <= 0) break block2;
                List waitingTask = this.tasksTable.getItems().stream().filter(task -> task.isState(1001)).collect(Collectors.toList());
                for (int i = 0; i < canRunTasksNumber && i < waitingTask.size(); ++i) {
                    ((SpiderWrapper)waitingTask.get(i)).run();
                }
                break block3;
            }
            if (canRunTasksNumber >= 0) break block3;
            List runningTask = this.tasksTable.getItems().stream().filter(task -> task.getSpider().isState(new int[]{2})).collect(Collectors.toList());
            for (int i = canRunTasksNumber; i < 0 && runningTask.size() + i >= 0; ++i) {
                ((SpiderWrapper)runningTask.get(runningTask.size() + i)).waiting();
            }
        }
    }

    private void createTask(BookBundle bundle) {
        DownloadConfig downloadConfig = SettingManager.manager().getDownload();
        String savePath = (String)downloadConfig.getFolder().getValue();
        if (!FileUtil.mkdir((String)savePath).exists()) {
            Toast.error((String)"\u4e0b\u8f7d\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u8bbe\u7f6e\u4e2d\u66f4\u6362");
            return;
        }
        Novel novel = bundle.getNovel();
        Spider spider = new Spider();
        spider.setUrl(novel.getUrl());
        spider.setNovel(bundle.getNovel());
        spider.setAnalyzerRule(bundle.getRule());
        spider.setRetryTimes(((Integer)downloadConfig.getRetryNum().getValue()).intValue());
        spider.setSavePath(savePath);
        spider.setThreadNum(((Integer)downloadConfig.getThreadNum().getValue()).intValue());
        SpiderWrapper spiderWrapper = new SpiderWrapper(spider, this::onCompleted);
        this.tasksTable.getItems().add((Object)spiderWrapper);
        if (this.canRunTasksNumber() > 0) {
            spiderWrapper.run();
        }
    }

    public int canRunTasksNumber() {
        Integer maxTaskNum = (Integer)SettingManager.manager().getDownload().getTaskNum().get();
        long currentRunning = this.tasksTable.getItems().stream().filter(task -> task.isState(2)).count();
        return (int)((long)maxTaskNum.intValue() - currentRunning);
    }

    public void restore() {
        if (FileUtil.exist((File)TMP_DIR)) {
            List names = FileUtil.listFileNames((String)TMP_DIR.getAbsolutePath());
            ArrayList<SpiderWrapper> tasks = new ArrayList<SpiderWrapper>();
            for (String name : names) {
                File file = FileUtil.file((File)TMP_DIR, (String)name);
                try {
                    String json = FileUtil.readUtf8String((File)file);
                    SpiderWrapper task = (SpiderWrapper)PropertyJsonSerializer.fromJson((String)json, SpiderWrapper.class);
                    task.setId(name);
                    task.init(this::onCompleted);
                    task.pause();
                    tasks.add(task);
                }
                catch (Exception e) {
                    log.warn("\u52a0\u8f7d\u4e0b\u8f7d\u4efb\u52a1\u5907\u4efd\u5931\u8d25\uff1a{}", (Object)file.getAbsoluteFile(), (Object)e);
                    FileUtil.del((File)file);
                }
            }
            this.tasksTable.getItems().setAll(tasks);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadManagerView)) {
            return false;
        }
        DownloadManagerView other = (DownloadManagerView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DownloadHistoryDao this$historyDao = this.historyDao;
        DownloadHistoryDao other$historyDao = other.historyDao;
        if (this$historyDao == null ? other$historyDao != null : !this$historyDao.equals(other$historyDao)) {
            return false;
        }
        TabButton this$tasksTab = this.tasksTab;
        TabButton other$tasksTab = other.tasksTab;
        if (this$tasksTab == null ? other$tasksTab != null : !this$tasksTab.equals(other$tasksTab)) {
            return false;
        }
        TabButton this$historyTab = this.historyTab;
        TabButton other$historyTab = other.historyTab;
        if (this$historyTab == null ? other$historyTab != null : !this$historyTab.equals(other$historyTab)) {
            return false;
        }
        VBox this$tasksPanel = this.tasksPanel;
        VBox other$tasksPanel = other.tasksPanel;
        if (this$tasksPanel == null ? other$tasksPanel != null : !this$tasksPanel.equals(other$tasksPanel)) {
            return false;
        }
        Node this$historyPanel = this.getHistoryPanel();
        Node other$historyPanel = other.getHistoryPanel();
        if (this$historyPanel == null ? other$historyPanel != null : !this$historyPanel.equals(other$historyPanel)) {
            return false;
        }
        TableView<SpiderWrapper> this$tasksTable = this.tasksTable;
        TableView<SpiderWrapper> other$tasksTable = other.tasksTable;
        if (this$tasksTable == null ? other$tasksTable != null : !this$tasksTable.equals(other$tasksTable)) {
            return false;
        }
        TableView<DownloadHistory> this$historyTable = this.getHistoryTable();
        TableView<DownloadHistory> other$historyTable = other.getHistoryTable();
        if (this$historyTable == null ? other$historyTable != null : !this$historyTable.equals(other$historyTable)) {
            return false;
        }
        StackPane this$container = this.container;
        StackPane other$container = other.container;
        return !(this$container == null ? other$container != null : !this$container.equals(other$container));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadManagerView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DownloadHistoryDao $historyDao = this.historyDao;
        result = result * 59 + ($historyDao == null ? 43 : $historyDao.hashCode());
        TabButton $tasksTab = this.tasksTab;
        result = result * 59 + ($tasksTab == null ? 43 : $tasksTab.hashCode());
        TabButton $historyTab = this.historyTab;
        result = result * 59 + ($historyTab == null ? 43 : $historyTab.hashCode());
        VBox $tasksPanel = this.tasksPanel;
        result = result * 59 + ($tasksPanel == null ? 43 : $tasksPanel.hashCode());
        Node $historyPanel = this.getHistoryPanel();
        result = result * 59 + ($historyPanel == null ? 43 : $historyPanel.hashCode());
        TableView<SpiderWrapper> $tasksTable = this.tasksTable;
        result = result * 59 + ($tasksTable == null ? 43 : $tasksTable.hashCode());
        TableView<DownloadHistory> $historyTable = this.getHistoryTable();
        result = result * 59 + ($historyTable == null ? 43 : $historyTable.hashCode());
        StackPane $container = this.container;
        result = result * 59 + ($container == null ? 43 : $container.hashCode());
        return result;
    }
}

