/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXDrawersStack;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXSlider;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.ChapterState;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.FluentTask;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.main.db.beans.AudioBook;
import com.unclezs.novel.app.main.db.dao.AudioBookDao;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.model.BookBundle;
import com.unclezs.novel.app.main.model.BookCache;
import com.unclezs.novel.app.main.util.BookHelper;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.util.TimeUtil;
import com.unclezs.novel.app.main.views.components.cell.AudioBookListCell;
import com.unclezs.novel.app.main.views.components.cell.TocListCell;
import com.unclezs.novel.app.main.views.home.DownloadManagerView;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.fxml.FXML;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/audio-bookshelf.fxml")
public class AudioBookShelfView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(AudioBookShelfView.class);
    public static final String BUNDLE_BOOK_KEY = "bundle-audio-book";
    public static final String CACHE_FOLDER_NAME = "audio";
    public static final File CACHE_FOLDER = ResourceManager.cacheFile("audio");
    private static final String INIT_TIME = "00:00";
    private static final String PAGE_NAME = "\u6709\u58f0\u4e66\u67b6";
    private final AudioBookDao audioBookDao = new AudioBookDao();
    private ProgressChangeListener progressChangeListener;
    @FXML
    private JFXProgressBar loading;
    @FXML
    private Icon playButton;
    @FXML
    private Label currentTime;
    @FXML
    private Label totalTime;
    @FXML
    private JFXSlider progress;
    @FXML
    private ContextMenu bookContextMenu;
    @FXML
    private Label titleLabel;
    @FXML
    private Label chapterLabel;
    @FXML
    private ListView<Chapter> tocListView;
    @FXML
    private ListView<AudioBook> bookListView;
    @FXML
    private JFXDrawer tocDrawer;
    @FXML
    private JFXDrawersStack drawer;
    private AudioBook currentBook;
    private MediaPlayer player;
    private FluentTask<Chapter> loadMediaTask = null;

    public void onCreated() {
        this.bookListView.setCellFactory(param -> new AudioBookListCell(this.bookContextMenu, book -> this.loadBook((AudioBook)book, true)));
        this.bookListView.getItems().addAll(this.audioBookDao.selectAll());
        this.bookListView.getItems().addListener(c -> {
            while (c.next()) {
                c.getRemoved().forEach(book -> {
                    if (book == this.currentBook) {
                        this.releaseResource();
                    }
                    this.audioBookDao.delete(book);
                    FileUtil.del((File)FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
                });
                c.getAddedSubList().forEach(this.audioBookDao::save);
            }
        });
        this.tocListView.setCellFactory(param -> new TocListCell());
        EventUtils.setOnMousePrimaryClick(this.tocListView, e -> {
            if (!this.tocListView.getSelectionModel().isEmpty()) {
                this.currentBook.setCurrentChapterIndex(this.tocListView.getSelectionModel().getSelectedIndex());
                this.drawer.toggle(this.tocDrawer);
                this.playChapter();
            }
        });
        this.initProgress();
        if (!this.bookListView.getItems().isEmpty()) {
            this.loadBook((AudioBook)this.bookListView.getItems().get(0), false);
            this.bookListView.getSelectionModel().selectFirst();
        }
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        BookBundle bookBundle = (BookBundle)bundle.get(BUNDLE_BOOK_KEY);
        if (bookBundle != null) {
            AudioBook book = AudioBook.fromBookBundle(bookBundle);
            int order = 1;
            for (Chapter chapter : book.getToc()) {
                chapter.setOrder(order++);
            }
            this.cacheBook(book);
            BookHelper.downloadCover(book.getCover(), book.getUrl(), FileUtil.file((File)CACHE_FOLDER, (String)book.getId()), cover -> {
                book.setCover((String)cover);
                this.audioBookDao.update(book);
            });
            this.bookListView.getItems().add((Object)book);
        }
    }

    public void onDestroy() {
        if (this.currentBook != null) {
            this.cacheBook(this.currentBook);
            this.audioBookDao.update(this.currentBook);
        }
    }

    public void addOrUpdateBook(AudioBook book) {
        this.bookListView.getItems().stream().filter(b -> Objects.equals(book.getId(), b.getId())).findFirst().ifPresent(arg_0 -> this.bookListView.getItems().remove(arg_0));
        this.bookListView.getItems().add((Object)book);
    }

    private void cacheBook(AudioBook book) {
        BookHelper.cache(new BookCache(book.getRule(), book.getToc()), FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
    }

    private void loadCache(AudioBook book) {
        BookCache bookCache = BookHelper.loadCache(FileUtil.file((File)CACHE_FOLDER, (String)book.getId()));
        book.setToc(bookCache.getToc());
        book.setRule(bookCache.getRule());
    }

    private void initProgress() {
        this.progress.setValueFactory(slider -> Bindings.createStringBinding(() -> {
            if (this.player == null) {
                return INIT_TIME;
            }
            double total = this.player.getTotalDuration().toSeconds();
            double current = total * slider.getValue();
            return TimeUtil.secondToTime(current) + "/" + TimeUtil.secondToTime(total);
        }, (Observable[])new Observable[]{this.progress.valueProperty()}));
        this.progress.valueChangingProperty().addListener(e -> {
            if (!this.progress.isValueChanging() && this.player != null) {
                this.player.seek(this.player.getStopTime().multiply(this.progress.getValue()));
            }
        });
        this.progress.valueProperty().addListener(e -> {
            if (!this.progress.isValueChanging() && this.player != null) {
                Duration to = this.player.getStopTime().multiply(this.progress.getValue());
                if (Math.abs(this.player.getCurrentTime().subtract(to).toSeconds()) > 1.0) {
                    this.player.seek(to);
                }
            }
        });
    }

    private void loadBook(AudioBook book, boolean play) {
        if (book == null || this.currentBook == book) {
            return;
        }
        if (this.currentBook != null) {
            this.cacheBook(this.currentBook);
            this.audioBookDao.update(this.currentBook);
        }
        this.currentBook = book;
        if (CollUtil.isEmpty(book.getToc())) {
            this.loadCache(this.currentBook);
        }
        this.titleLabel.setText(book.getName());
        this.playChapter(this.currentBook.getCurrentProgress(), play);
    }

    @FXML
    private void showToc() {
        if (this.currentBook == null) {
            return;
        }
        this.tocListView.getItems().setAll(this.currentBook.getToc());
        this.tocListView.getSelectionModel().select(this.currentBook.getCurrentChapterIndex());
        this.drawer.toggle(this.tocDrawer);
    }

    @FXML
    private void removeBook() {
        if (this.bookListView.getSelectionModel().isEmpty()) {
            return;
        }
        AudioBook book = (AudioBook)this.bookListView.getSelectionModel().getSelectedItem();
        this.bookListView.getItems().remove((Object)book);
        log.trace("\u4ece\u4e66\u67b6\u79fb\u9664\u6709\u58f0\u5c0f\u8bf4: {}", (Object)book);
    }

    @FXML
    private void playPrevious() {
        if (this.player != null && this.currentBook != null && this.currentBook.getCurrentChapterIndex() > 0) {
            this.currentBook.setCurrentChapterIndex(this.currentBook.getCurrentChapterIndex() - 1);
            this.playChapter();
        }
    }

    @FXML
    private void playNext() {
        if (this.player != null && this.currentBook != null && this.currentBook.getCurrentChapterIndex() < this.currentBook.getToc().size() - 1) {
            this.currentBook.setCurrentChapterIndex(this.currentBook.getCurrentChapterIndex() + 1);
            this.playChapter();
        }
    }

    private void playChapter() {
        this.playChapter(0.0, true);
    }

    private void playChapter(double initProgress, boolean play) {
        if (this.currentBook.getToc().isEmpty()) {
            return;
        }
        Chapter chapter = this.currentBook.getToc().get(this.currentBook.getCurrentChapterIndex());
        this.loading.setVisible(true);
        this.chapterLabel.setText(chapter.getName());
        this.currentBook.setCurrentChapterName(chapter.getName());
        if (chapter.getContent() == null || UrlUtils.isHttpUrl((String)chapter.getContent())) {
            this.loadChapter(initProgress, play, chapter);
        } else {
            this.initPlayer(chapter, initProgress, play);
        }
        int next = this.currentBook.getCurrentChapterIndex() + 1;
        if (next < this.currentBook.getToc().size()) {
            this.loadChapter(this.currentBook, next);
        }
    }

    private void loadChapter(double initProgress, boolean play, final Chapter chapter) {
        if (this.loadMediaTask != null) {
            this.loadMediaTask.cancel();
        }
        this.loadMediaTask = new FluentTask<Chapter>(false){

            protected Chapter call() {
                AudioBookShelfView.this.loadChapter(AudioBookShelfView.this.currentBook, chapter);
                return chapter;
            }
        }.onSuccess(c -> this.initPlayer((Chapter)c, initProgress, play)).onFailed(e -> {
            if (play) {
                Toast.error((String)"\u97f3\u9891\u83b7\u53d6\u5931\u8d25");
            }
            log.error("\u83b7\u53d6\u97f3\u9891\u5931\u8d25\uff1a{}", (Object)chapter, e);
            this.loading.setVisible(false);
        });
        this.loadMediaTask.start();
    }

    private void loadChapter(AudioBook book, int index) {
        Chapter chapter = book.getToc().get(index);
        if (chapter.getContent() != null && !UrlUtils.isHttpUrl((String)chapter.getContent())) {
            return;
        }
        Executor.run(() -> this.loadChapter(book, chapter));
    }

    private void loadChapter(AudioBook book, Chapter chapter) {
        try {
            String mediaUrl = chapter.getContent();
            if (!UrlUtils.isHttpUrl((String)mediaUrl)) {
                mediaUrl = new NovelSpider(book.getRule()).content(chapter.getUrl());
                chapter.setContent(mediaUrl);
                chapter.setState(ChapterState.DOWNLOADED);
            }
            log.trace("\u83b7\u53d6\u5230\u97f3\u9891\u5a92\u4f53\u5730\u5740\uff1a{}", (Object)mediaUrl);
        }
        catch (Exception e) {
            log.warn("\u9884\u52a0\u8f7d\u6709\u58f0\u7ae0\u8282\u5931\u8d25\uff1a{}", (Object)chapter, (Object)e);
        }
    }

    @FXML
    private void play(MouseEvent event) {
        Icon playBtn = (Icon)event.getSource();
        if (IconFont.PLAY.name().equalsIgnoreCase(playBtn.getValue().toString())) {
            this.play();
        } else {
            this.pause();
        }
    }

    private void play() {
        if (this.player != null && this.currentBook != null) {
            this.playButton.setValue((Object)IconFont.PLAY_PAUSE);
            this.player.play();
        }
    }

    private void pause() {
        if (this.player != null && this.currentBook != null) {
            this.playButton.setValue((Object)IconFont.PLAY);
            this.player.pause();
        }
    }

    private void releaseResource() {
        if (this.loadMediaTask != null) {
            this.loadMediaTask.cancel();
        }
        if (this.player != null) {
            this.pause();
            this.player.dispose();
        }
        this.currentBook = null;
    }

    private void initPlayer(Chapter chapter, double initProgress, boolean play) {
        if (chapter.getState() != ChapterState.DOWNLOADED && StringUtils.isBlank((CharSequence)chapter.getUrl())) {
            return;
        }
        Media media = new Media(chapter.getUrl());
        if (this.player != null) {
            this.pause();
            this.player.dispose();
            this.player.currentTimeProperty().removeListener((InvalidationListener)this.progressChangeListener);
        } else {
            this.progressChangeListener = new ProgressChangeListener();
        }
        this.player = new MediaPlayer(media);
        this.player.currentTimeProperty().addListener((InvalidationListener)this.progressChangeListener);
        this.player.setOnError(() -> {
            if (play) {
                Toast.error((String)("\u97f3\u9891\u64ad\u653e\u5931\u8d25\uff1a" + this.player.getError().getType()));
            }
            this.loading.setVisible(false);
        });
        this.player.setOnReady(() -> {
            this.currentTime.setText(INIT_TIME);
            this.totalTime.setText(TimeUtil.secondToTime(this.player.getStopTime().toSeconds()));
            this.player.seek(this.player.getStopTime().multiply(initProgress));
            this.progress.setValue(initProgress);
            if (play) {
                this.play();
            }
            this.loading.setVisible(false);
        });
        this.player.setOnEndOfMedia(this::playNext);
    }

    @FXML
    private void download() {
        if (this.bookListView.getSelectionModel().isEmpty()) {
            return;
        }
        AudioBook book = (AudioBook)this.bookListView.getSelectionModel().getSelectedItem();
        this.loadCache(book);
        BookBundle bundle = new BookBundle(book.toNovel(), this.currentBook.getRule());
        bundle.getNovel().setChapters(book.getToc());
        this.navigation.navigate(DownloadManagerView.class, (SidebarNavigateBundle)new SidebarNavigateBundle().put("bundle_download_key", (Object)bundle));
    }

    @FXML
    private void openBrowser() {
        if (this.currentBook != null) {
            DesktopUtils.openBrowse((String)this.currentBook.getUrl());
        }
    }

    private <T> void withAudioUrl(BiFunction<String, String, T> audioUrlHandler, Consumer<T> onSuccessHandler) {
        MultipleSelectionModel selectionModel = this.tocListView.getSelectionModel();
        if (selectionModel.isEmpty()) {
            return;
        }
        AudioBook novel = (AudioBook)this.bookListView.getSelectionModel().getSelectedItem();
        Chapter chapter = (Chapter)selectionModel.getSelectedItem();
        String url = chapter.getUrl();
        NovelSpider spider = new NovelSpider(novel.getRule());
        TaskFactory.create(() -> {
            String audioUrl = spider.content(url);
            return audioUrlHandler.apply(url, audioUrl);
        }).onSuccess(onSuccessHandler).onFailed(e -> Toast.error((String)"\u83b7\u53d6\u97f3\u9891\u5931\u8d25")).start();
    }

    @FXML
    private void checkAudioEffective() {
        this.withAudioUrl((chapterUrl, audioUrl) -> {
            AtomicBoolean validate = new AtomicBoolean(false);
            try {
                RequestParams params = RequestParams.create((String)audioUrl);
                params.addHeader("Referer", chapterUrl);
                validate.set(Http.validate((RequestParams)params));
            }
            catch (Exception e) {
                log.warn("\u97f3\u9891\u68c0\u6d4b\u5931\u8d25: \u7ae0\u8282\uff1a{} \u97f3\u9891:{}", new Object[]{chapterUrl, audioUrl, e});
            }
            return validate.get();
        }, validate -> {
            if (Boolean.TRUE.equals(validate)) {
                Toast.success((String)"\u97f3\u9891\u6709\u6548");
            } else {
                Toast.error((String)"\u97f3\u9891\u65e0\u6548");
            }
        });
    }

    @FXML
    private void openChapterLinkBrowser() {
        String url = ((Chapter)this.tocListView.getSelectionModel().getSelectedItem()).getUrl();
        if (UrlUtils.isHttpUrl((String)url)) {
            DesktopUtils.openBrowse((String)url);
        }
    }

    @FXML
    private void copyAudioLink() {
        this.withAudioUrl((chapterUrl, audioUrl) -> audioUrl, audioUrl -> {
            DesktopUtils.copy((String)audioUrl);
            Toast.success((String)"\u590d\u5236\u6210\u529f");
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioBookShelfView)) {
            return false;
        }
        AudioBookShelfView other = (AudioBookShelfView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AudioBookDao this$audioBookDao = this.audioBookDao;
        AudioBookDao other$audioBookDao = other.audioBookDao;
        if (this$audioBookDao == null ? other$audioBookDao != null : !this$audioBookDao.equals(other$audioBookDao)) {
            return false;
        }
        ProgressChangeListener this$progressChangeListener = this.progressChangeListener;
        ProgressChangeListener other$progressChangeListener = other.progressChangeListener;
        if (this$progressChangeListener == null ? other$progressChangeListener != null : !this$progressChangeListener.equals(other$progressChangeListener)) {
            return false;
        }
        JFXProgressBar this$loading = this.loading;
        JFXProgressBar other$loading = other.loading;
        if (this$loading == null ? other$loading != null : !this$loading.equals(other$loading)) {
            return false;
        }
        Icon this$playButton = this.playButton;
        Icon other$playButton = other.playButton;
        if (this$playButton == null ? other$playButton != null : !this$playButton.equals(other$playButton)) {
            return false;
        }
        Label this$currentTime = this.currentTime;
        Label other$currentTime = other.currentTime;
        if (this$currentTime == null ? other$currentTime != null : !this$currentTime.equals(other$currentTime)) {
            return false;
        }
        Label this$totalTime = this.totalTime;
        Label other$totalTime = other.totalTime;
        if (this$totalTime == null ? other$totalTime != null : !this$totalTime.equals(other$totalTime)) {
            return false;
        }
        JFXSlider this$progress = this.progress;
        JFXSlider other$progress = other.progress;
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        ContextMenu this$bookContextMenu = this.bookContextMenu;
        ContextMenu other$bookContextMenu = other.bookContextMenu;
        if (this$bookContextMenu == null ? other$bookContextMenu != null : !this$bookContextMenu.equals(other$bookContextMenu)) {
            return false;
        }
        Label this$titleLabel = this.titleLabel;
        Label other$titleLabel = other.titleLabel;
        if (this$titleLabel == null ? other$titleLabel != null : !this$titleLabel.equals(other$titleLabel)) {
            return false;
        }
        Label this$chapterLabel = this.chapterLabel;
        Label other$chapterLabel = other.chapterLabel;
        if (this$chapterLabel == null ? other$chapterLabel != null : !this$chapterLabel.equals(other$chapterLabel)) {
            return false;
        }
        ListView<Chapter> this$tocListView = this.tocListView;
        ListView<Chapter> other$tocListView = other.tocListView;
        if (this$tocListView == null ? other$tocListView != null : !this$tocListView.equals(other$tocListView)) {
            return false;
        }
        ListView<AudioBook> this$bookListView = this.bookListView;
        ListView<AudioBook> other$bookListView = other.bookListView;
        if (this$bookListView == null ? other$bookListView != null : !this$bookListView.equals(other$bookListView)) {
            return false;
        }
        JFXDrawer this$tocDrawer = this.tocDrawer;
        JFXDrawer other$tocDrawer = other.tocDrawer;
        if (this$tocDrawer == null ? other$tocDrawer != null : !this$tocDrawer.equals(other$tocDrawer)) {
            return false;
        }
        JFXDrawersStack this$drawer = this.drawer;
        JFXDrawersStack other$drawer = other.drawer;
        if (this$drawer == null ? other$drawer != null : !this$drawer.equals(other$drawer)) {
            return false;
        }
        AudioBook this$currentBook = this.currentBook;
        AudioBook other$currentBook = other.currentBook;
        if (this$currentBook == null ? other$currentBook != null : !((Object)this$currentBook).equals(other$currentBook)) {
            return false;
        }
        MediaPlayer this$player = this.player;
        MediaPlayer other$player = other.player;
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        FluentTask<Chapter> this$loadMediaTask = this.loadMediaTask;
        FluentTask<Chapter> other$loadMediaTask = other.loadMediaTask;
        return !(this$loadMediaTask == null ? other$loadMediaTask != null : !this$loadMediaTask.equals(other$loadMediaTask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioBookShelfView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AudioBookDao $audioBookDao = this.audioBookDao;
        result = result * 59 + ($audioBookDao == null ? 43 : $audioBookDao.hashCode());
        ProgressChangeListener $progressChangeListener = this.progressChangeListener;
        result = result * 59 + ($progressChangeListener == null ? 43 : $progressChangeListener.hashCode());
        JFXProgressBar $loading = this.loading;
        result = result * 59 + ($loading == null ? 43 : $loading.hashCode());
        Icon $playButton = this.playButton;
        result = result * 59 + ($playButton == null ? 43 : $playButton.hashCode());
        Label $currentTime = this.currentTime;
        result = result * 59 + ($currentTime == null ? 43 : $currentTime.hashCode());
        Label $totalTime = this.totalTime;
        result = result * 59 + ($totalTime == null ? 43 : $totalTime.hashCode());
        JFXSlider $progress = this.progress;
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        ContextMenu $bookContextMenu = this.bookContextMenu;
        result = result * 59 + ($bookContextMenu == null ? 43 : $bookContextMenu.hashCode());
        Label $titleLabel = this.titleLabel;
        result = result * 59 + ($titleLabel == null ? 43 : $titleLabel.hashCode());
        Label $chapterLabel = this.chapterLabel;
        result = result * 59 + ($chapterLabel == null ? 43 : $chapterLabel.hashCode());
        ListView<Chapter> $tocListView = this.tocListView;
        result = result * 59 + ($tocListView == null ? 43 : $tocListView.hashCode());
        ListView<AudioBook> $bookListView = this.bookListView;
        result = result * 59 + ($bookListView == null ? 43 : $bookListView.hashCode());
        JFXDrawer $tocDrawer = this.tocDrawer;
        result = result * 59 + ($tocDrawer == null ? 43 : $tocDrawer.hashCode());
        JFXDrawersStack $drawer = this.drawer;
        result = result * 59 + ($drawer == null ? 43 : $drawer.hashCode());
        AudioBook $currentBook = this.currentBook;
        result = result * 59 + ($currentBook == null ? 43 : ((Object)$currentBook).hashCode());
        MediaPlayer $player = this.player;
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        FluentTask<Chapter> $loadMediaTask = this.loadMediaTask;
        result = result * 59 + ($loadMediaTask == null ? 43 : $loadMediaTask.hashCode());
        return result;
    }

    private class ProgressChangeListener
    implements InvalidationListener {
        private ProgressChangeListener() {
        }

        public void invalidated(Observable observable) {
            if (AudioBookShelfView.this.player.getCurrentTime().lessThanOrEqualTo(AudioBookShelfView.this.player.getStopTime())) {
                double current = AudioBookShelfView.this.player.getCurrentTime().toSeconds();
                double total = AudioBookShelfView.this.player.getStopTime().toSeconds();
                AudioBookShelfView.this.currentTime.setText(TimeUtil.secondToTime(current));
                double to = total * AudioBookShelfView.this.progress.getValue();
                if (Math.abs(current - to) < 1.0) {
                    AudioBookShelfView.this.progress.setValue(current / total);
                }
                AudioBookShelfView.this.currentBook.setCurrentProgress(AudioBookShelfView.this.progress.getValue());
            }
        }
    }
}

