/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.jfoenix.controls.JFXNodesList;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.script.ScriptUtils;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.spider.TocSpider;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.InputBox;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.main.core.ChapterComparator;
import com.unclezs.novel.app.main.manager.RuleManager;
import com.unclezs.novel.app.main.model.ChapterProperty;
import com.unclezs.novel.app.main.util.BookHelper;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.BookDetailModal;
import com.unclezs.novel.app.main.views.components.cell.ChapterListCell;
import com.unclezs.novel.app.main.views.home.RuleEditorView;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/analysis.fxml")
public class AnalysisView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(AnalysisView.class);
    public static final String BUNDLE_KEY_NOVEL_INFO = "novel-info";
    public static final String PAGE_NAME = "\u89e3\u6790\u4e0b\u8f7d";
    private final TextArea content = new TextArea();
    @FXML
    private JFXNodesList floatButtons;
    @FXML
    private HBox contentPanel;
    @FXML
    private ListView<ChapterProperty> listView;
    @FXML
    private InputBox inputBox;
    private AnalyzerRule rule;
    private Novel novel;
    private TocSpider tocSpider;

    public void onCreate() {
        TextField input = this.inputBox.getInput();
        input.focusedProperty().addListener(e -> {
            if (input.isFocused()) {
                String tocUrl = Clipboard.getSystemClipboard().getString();
                if (!Objects.equals(input.getText(), tocUrl) && UrlUtils.isHttpUrl((String)tocUrl)) {
                    input.setText(tocUrl);
                }
            }
        });
        this.listView.setCellFactory(param -> new ChapterListCell());
        this.content.setWrapText(true);
        this.content.prefWidthProperty().bind((ObservableValue)this.contentPanel.widthProperty().multiply(0.5));
        this.listView.prefWidthProperty().bind((ObservableValue)this.contentPanel.widthProperty().multiply(0.5));
        this.contentPanel.getChildren().remove((Object)this.content);
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        EventUtils.setOnMouseDoubleClick(this.listView, event -> this.analysisContent());
        this.listView.setOnContextMenuRequested(e -> {
            if (this.listView.getSelectionModel().isEmpty()) {
                this.listView.getContextMenu().hide();
            }
        });
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        Novel novelInfo = (Novel)bundle.get(BUNDLE_KEY_NOVEL_INFO);
        if (novelInfo != null) {
            this.novel = novelInfo;
            this.inputBox.getInput().setText(this.novel.getUrl());
            this.inputBox.fire();
        }
    }

    public void onAnalysis(InputBox.ActionClickedEvent event) {
        String tocUrl = event.getInput();
        if (!UrlUtils.isHttpUrl((String)tocUrl)) {
            Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u76ee\u5f55\u5730\u5740");
            return;
        }
        this.listView.getItems().clear();
        this.contentPanel.getChildren().remove((Object)this.content);
        if (this.novel != null && !Objects.equals(tocUrl, this.novel.getUrl())) {
            this.novel = null;
        }
        if (this.rule == null || !Objects.equals(this.rule.getSite(), UrlUtils.getSite((String)tocUrl))) {
            String site = tocUrl;
            if (this.novel != null && (site = this.novel.getSite()) == null) {
                site = UrlUtils.getSite((String)this.novel.getUrl());
            }
            this.rule = RuleManager.getOrDefault(site);
        }
        this.tocSpider = new TocSpider(this.rule);
        this.tocSpider.setOnNewItemAddHandler(chapter -> Executor.runFx(() -> this.listView.getItems().add((Object)new ChapterProperty((Chapter)chapter))));
        TaskFactory.create(() -> {
            this.tocSpider.toc(tocUrl);
            Novel novelInfo = this.tocSpider.getNovel();
            if (this.novel != null) {
                BeanUtil.copyProperties((Object)this.novel, (Object)novelInfo, (CopyOptions)CopyOptions.create().ignoreNullValue());
            }
            this.novel = novelInfo;
            this.novel.setUrl(tocUrl);
            if (Boolean.TRUE.equals(this.rule.getToc().getAutoNext())) {
                this.tocSpider.loadAll();
            }
            return null;
        }).onSuccess(value -> {
            if (StringUtils.isBlank((CharSequence)this.rule.getName())) {
                this.rule.setName(this.novel.getTitle());
            }
        }).onFailed(e -> {
            log.error("\u76ee\u5f55\u89e3\u6790\u5931\u8d25", e);
            Toast.error((String)"\u52a0\u8f7d\u5931\u8d25");
        }).onFinally(this::checkHasMore).start();
    }

    private void loadMore() {
        if (this.tocSpider == null) {
            return;
        }
        this.listView.getItems().remove(this.listView.getItems().size() - 1);
        TaskFactory.create(() -> {
            this.tocSpider.loadMore();
            if (Boolean.TRUE.equals(this.rule.getToc().getAutoNext())) {
                this.tocSpider.loadAll();
            }
            return null;
        }).onFailed(e -> {
            log.error("\u76ee\u5f55\u89e3\u6790\u5931\u8d25", e);
            Toast.error((String)"\u52a0\u8f7d\u5931\u8d25");
        }).onFinally(this::checkHasMore).start();
    }

    @FXML
    private void analysisContent() {
        if (!this.listView.getSelectionModel().isEmpty()) {
            Chapter item = ((ChapterProperty)this.listView.getSelectionModel().getSelectedItem()).getChapter();
            if (item == null) {
                this.loadMore();
                return;
            }
            if (this.contentPanel.getChildren().size() == 1) {
                this.contentPanel.getChildren().add((Object)this.content);
            }
            TaskFactory.create(() -> {
                NovelSpider spider = new NovelSpider(this.rule);
                String chapterContent = spider.content(item.getUrl());
                if (Boolean.TRUE.equals(this.rule.getContent().getRemoveTitle())) {
                    chapterContent = SpiderHelper.removeTitle((String)chapterContent, (String)item.getName());
                }
                return chapterContent;
            }).onSuccess(pages -> {
                if (pages != null) {
                    this.content.setText(pages);
                }
            }).start();
        }
    }

    private void checkHasMore() {
        if (!this.listView.getItems().isEmpty() && this.tocSpider.hasMore()) {
            this.listView.getItems().add((Object)new ChapterProperty(null));
        }
    }

    public void checkedAll() {
        this.listView.getItems().forEach(item -> item.setSelected(true));
        this.listView.getSelectionModel().selectAll();
        this.listView.refresh();
    }

    public void uncheckedAll() {
        this.listView.getItems().forEach(item -> item.setSelected(false));
        this.listView.getSelectionModel().clearSelection();
        this.listView.refresh();
    }

    @FXML
    private void removeSelected() {
        this.listView.getItems().removeAll((Collection)this.listView.getSelectionModel().getSelectedItems());
    }

    @FXML
    private void reverseToc() {
        Collections.reverse(this.listView.getItems());
        this.rule.getToc().setReverse(Boolean.valueOf(!Boolean.TRUE.equals(this.rule.getToc().getReverse())));
    }

    @FXML
    private void sortToc() {
        if (StringUtils.isBlank((CharSequence)this.rule.getToc().getSortScript())) {
            this.listView.getItems().sort((Comparator)new ChapterComparator());
        } else {
            this.listView.getItems().sort((o1, o2) -> {
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("a", (Object)o1.getChapter());
                bindings.put("b", (Object)o2.getChapter());
                return (int)Double.parseDouble(ScriptUtils.execute((String)this.rule.getToc().getSortScript(), (Bindings)bindings));
            });
        }
        this.rule.getToc().setSort(Boolean.valueOf(!Boolean.TRUE.equals(this.rule.getToc().getSort())));
    }

    @FXML
    private void openBrowser() {
        String url = ((ChapterProperty)this.listView.getSelectionModel().getSelectedItem()).getChapter().getUrl();
        if (UrlUtils.isHttpUrl((String)url)) {
            DesktopUtils.openBrowse((String)url);
        }
    }

    @FXML
    private void renameChapterNames() {
        String defaultTemplate = "\u7b2c{{\u7ae0\u8282\u5e8f\u53f7}}\u7ae0 {{\u7ae0\u8282\u540d}}";
        ModalBox.input((String)defaultTemplate, (String)"\u8bf7\u8f93\u5165\u7ae0\u8282\u91cd\u547d\u540d\u6a21\u677f", template -> {
            int index = 1;
            ObservableList items = this.listView.getItems();
            for (int i = 0; i < this.listView.getItems().size(); ++i) {
                ChapterProperty chapter = (ChapterProperty)items.get(i);
                if (!chapter.isSelected()) continue;
                String name = chapter.getChapter().getName();
                name = StringUtils.remove((String)name, (String[])new String[]{"[0-9]", "\u7b2c.*?\u7ae0"});
                String newName = template.replace("{{\u7ae0\u8282\u5e8f\u53f7}}", String.valueOf(index++)).replace("{{\u7ae0\u8282\u540d}}", name);
                chapter.getChapter().setName(newName);
            }
            this.listView.refresh();
        }).title("\u91cd\u547d\u540d\u7ae0\u8282\u6a21\u677f\u8bbe\u7f6e").show();
    }

    @FXML
    public void configRule() {
        if (this.rule == null) {
            Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u8bf7\u5148\u89e3\u6790\u76ee\u5f55~");
            return;
        }
        SidebarNavigateBundle bundle = (SidebarNavigateBundle)new SidebarNavigateBundle().put("rule", (Object)this.rule);
        this.navigation.navigate(RuleEditorView.class, bundle);
    }

    @FXML
    private void displayDetail() {
        if (this.novel == null) {
            Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u8bf7\u5148\u89e3\u6790\u76ee\u5f55~");
            return;
        }
        ModalBox.none().body((Node)new BookDetailModal(this.novel, false, true)).cancel("\u5173\u95ed").title("\u5c0f\u8bf4\u8be6\u60c5").show();
        this.floatButtons.animateList(false);
    }

    @FXML
    private void download() {
        if (this.novel == null) {
            Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u8bf7\u5148\u89e3\u6790\u76ee\u5f55~");
            return;
        }
        List<Chapter> selectedChapters = this.selectedChapters();
        if (selectedChapters.isEmpty()) {
            Toast.error((String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u7ae0\u8282");
            return;
        }
        BookHelper.submitDownload(this.novel, this.rule, selectedChapters);
    }

    public void addToBookShelf() {
        this.novel.setChapters(this.selectedChapters());
        Set blackChapterUrls = this.listView.getItems().stream().filter(chapterProperty -> chapterProperty.getChapter() != null && !chapterProperty.isSelected()).map(chapterProperty -> chapterProperty.getChapter().getUrl()).collect(Collectors.toSet());
        this.rule.getToc().setBlackUrls(blackChapterUrls);
        BookHelper.addBookShelf(Boolean.TRUE.equals(this.rule.getAudio()), this.novel, this.rule, null);
    }

    private List<Chapter> selectedChapters() {
        return this.listView.getItems().stream().filter(chapterProperty -> chapterProperty.isSelected() && chapterProperty.getChapter() != null).map(ChapterProperty::getChapter).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisView)) {
            return false;
        }
        AnalysisView other = (AnalysisView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextArea this$content = this.content;
        TextArea other$content = other.content;
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        JFXNodesList this$floatButtons = this.floatButtons;
        JFXNodesList other$floatButtons = other.floatButtons;
        if (this$floatButtons == null ? other$floatButtons != null : !this$floatButtons.equals(other$floatButtons)) {
            return false;
        }
        HBox this$contentPanel = this.contentPanel;
        HBox other$contentPanel = other.contentPanel;
        if (this$contentPanel == null ? other$contentPanel != null : !this$contentPanel.equals(other$contentPanel)) {
            return false;
        }
        ListView<ChapterProperty> this$listView = this.listView;
        ListView<ChapterProperty> other$listView = other.listView;
        if (this$listView == null ? other$listView != null : !this$listView.equals(other$listView)) {
            return false;
        }
        InputBox this$inputBox = this.inputBox;
        InputBox other$inputBox = other.inputBox;
        if (this$inputBox == null ? other$inputBox != null : !this$inputBox.equals(other$inputBox)) {
            return false;
        }
        AnalyzerRule this$rule = this.rule;
        AnalyzerRule other$rule = other.rule;
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        Novel this$novel = this.novel;
        Novel other$novel = other.novel;
        if (this$novel == null ? other$novel != null : !this$novel.equals(other$novel)) {
            return false;
        }
        TocSpider this$tocSpider = this.tocSpider;
        TocSpider other$tocSpider = other.tocSpider;
        return !(this$tocSpider == null ? other$tocSpider != null : !this$tocSpider.equals(other$tocSpider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalysisView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TextArea $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        JFXNodesList $floatButtons = this.floatButtons;
        result = result * 59 + ($floatButtons == null ? 43 : $floatButtons.hashCode());
        HBox $contentPanel = this.contentPanel;
        result = result * 59 + ($contentPanel == null ? 43 : $contentPanel.hashCode());
        ListView<ChapterProperty> $listView = this.listView;
        result = result * 59 + ($listView == null ? 43 : $listView.hashCode());
        InputBox $inputBox = this.inputBox;
        result = result * 59 + ($inputBox == null ? 43 : $inputBox.hashCode());
        AnalyzerRule $rule = this.rule;
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        Novel $novel = this.novel;
        result = result * 59 + ($novel == null ? 43 : $novel.hashCode());
        TocSpider $tocSpider = this.tocSpider;
        result = result * 59 + ($tocSpider == null ? 43 : $tocSpider.hashCode());
        return result;
    }
}

