/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.setting;

import cn.hutool.core.bean.BeanUtil;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.db.beans.SearchEngine;
import com.unclezs.novel.app.main.db.dao.SearchEngineDao;
import com.unclezs.novel.app.main.views.components.cell.ActionButtonTableCell;
import com.unclezs.novel.app.main.views.components.cell.CheckBoxTableCell;
import com.unclezs.novel.app.main.views.components.setting.SearchEngineEditor;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineSetting
extends VBox
implements LocalizedSupport {
    private static final Logger log = LoggerFactory.getLogger(SearchEngineSetting.class);
    private final TableView<SearchEngine> table = new TableView();

    public SearchEngineSetting() {
        NodeHelper.addClass((Styleable)this, (String[])new String[]{"search-engine-manager"});
        IconButton add = (IconButton)NodeHelper.addClass((Styleable)new IconButton(this.localized("setting.search.engine.add"), IconFont.PLUS), (String[])new String[]{"btn"});
        IconButton importDefault = (IconButton)NodeHelper.addClass((Styleable)new IconButton(this.localized("setting.search.engine.default"), IconFont.IMPORT), (String[])new String[]{"btn"});
        add.setOnAction(e -> this.addSearchEngine());
        importDefault.setOnAction(e -> this.importDefaultSearchEngines());
        HBox actions = (HBox)NodeHelper.addClass((Styleable)new HBox(new Node[]{importDefault, add}), (String[])new String[]{"actions"});
        this.getChildren().addAll((Object[])new Node[]{actions, this.table});
        this.table.setItems(SearchEngineDao.me().all());
        this.createColumns();
        this.table.getSelectionModel().selectFirst();
    }

    private void createColumns() {
        TableColumn id = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn("#"), (String[])new String[]{"id"});
        id.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.1));
        id.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)(this.table.getItems().indexOf(param.getValue()) + 1)));
        TableColumn name = new TableColumn(this.localized("setting.search.engine.name"));
        name.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.2));
        name.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((SearchEngine)param.getValue()).getName()));
        TableColumn domain = new TableColumn(this.localized("setting.search.engine.host"));
        domain.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.2));
        domain.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((SearchEngine)param.getValue()).getDomain()));
        TableColumn enabled = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("setting.search.engine.enabled")), (String[])new String[]{"align-center"});
        enabled.setCellValueFactory(col -> new ReadOnlyBooleanWrapper(Boolean.TRUE.equals(((SearchEngine)col.getValue()).getEnabled())));
        enabled.setCellFactory(col -> new CheckBoxTableCell(this::onSearchEngineEnabledChange));
        enabled.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.2));
        TableColumn operation = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("setting.search.engine.actions")), (String[])new String[]{"align-center"});
        operation.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.2));
        operation.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((SearchEngine)col.getValue())));
        operation.setCellFactory(col -> new ActionButtonTableCell<SearchEngine>(this::onEditSearchEngine, this::onDeleteSearchEngine));
        this.table.getColumns().addAll((Object[])new TableColumn[]{id, name, domain, enabled, operation});
        this.table.getColumns().forEach(column -> column.setResizable(false));
        this.table.getSelectionModel().selectFirst();
    }

    private void onDeleteSearchEngine(SearchEngine searchEngine, int index) {
        ModalBox.confirm(delete -> {
            if (Boolean.TRUE.equals(delete)) {
                SearchEngineDao.me().delete((SearchEngine)this.table.getItems().get(index));
                this.table.getItems().remove(index);
            }
        }).title("\u786e\u5b9a\u5220\u9664\u5417\uff1f").message(String.format("\u662f\u5426\u5220\u9664\u89c4\u5219\uff1a%s", searchEngine.getName())).show();
    }

    private void onEditSearchEngine(SearchEngine searchEngine, int index) {
        SearchEngineEditor editor = new SearchEngineEditor((SearchEngine)BeanUtil.toBean((Object)searchEngine, SearchEngine.class));
        ModalBox.confirm(save -> {
            if (Boolean.TRUE.equals(save)) {
                BeanUtil.copyProperties((Object)editor.getResult(), (Object)searchEngine, (String[])new String[0]);
                SearchEngineDao.me().update(searchEngine);
                this.table.refresh();
            }
        }).body((Node)editor).title("\u7f16\u8f91\u641c\u7d22\u5f15\u64ce").show();
    }

    private void onSearchEngineEnabledChange(Boolean enabled, int index) {
        SearchEngine engine = (SearchEngine)this.table.getItems().get(index);
        if (Objects.equals(engine.getEnabled(), enabled)) {
            return;
        }
        SearchEngineDao.me().update(engine);
        engine.setEnabled(Boolean.TRUE.equals(enabled));
    }

    public void addSearchEngine() {
        SearchEngineEditor editor = new SearchEngineEditor(new SearchEngine());
        AtomicBoolean validate = new AtomicBoolean(true);
        ModalBox.confirm(save -> {
            if (Boolean.TRUE.equals(save)) {
                SearchEngine engine = editor.getResult();
                if (StringUtils.isBlank((CharSequence)engine.getUrl()) || StringUtils.isBlank((CharSequence)engine.getName())) {
                    Toast.error((StackPane)((StackPane)editor.getParent()), (String)"\u540d\u79f0\u4e0e\u641c\u7d22\u7f51\u5740\u5fc5\u987b\u586b\u5199");
                    validate.set(false);
                    return;
                }
                if (!UrlUtils.isHttpUrl((String)engine.getUrl())) {
                    Toast.error((StackPane)((StackPane)editor.getParent()), (String)"\u641c\u7d22\u7f51\u5740\u5fc5\u987b\u4e3aHTTP\u94fe\u63a5");
                    validate.set(false);
                    return;
                }
                SearchEngineDao.me().save(engine);
                this.table.getItems().add((Object)engine);
            }
        }).body((Node)editor).success(() -> {
            boolean success = validate.get();
            validate.set(true);
            return success;
        }).title("\u6dfb\u52a0\u641c\u7d22\u5f15\u64ce").show();
    }

    private void importDefaultSearchEngines() {
        List<SearchEngine> engines = SearchEngine.getDefault();
        this.table.getItems().addAll(SearchEngine.getDefault());
        try {
            SearchEngineDao.me().getDao().create(engines);
        }
        catch (SQLException e) {
            log.error("\u6dfb\u52a0\u9ed8\u8ba4\u641c\u7d22\u5f15\u64ce\u5931\u8d25", (Throwable)e);
        }
    }
}

