/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.setting;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.db.beans.SearchEngine;
import java.io.File;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class SearchEngineEditor
extends VBox {
    public static final String DEFAULT_STYLE_CLASS = "search-engine-editor";
    private final TextField nameInput = new TextField();
    private final TextField searchInput = new TextField();
    private final TextField stylesheetInput = new TextField();
    private final SearchEngine engine;

    public SearchEngineEditor(SearchEngine engine) {
        this.engine = engine;
        NodeHelper.addClass((Styleable)this, (String[])new String[]{DEFAULT_STYLE_CLASS});
        Label nameLabel = new Label("\u540d\u79f0");
        this.nameInput.setText(engine.getName());
        this.nameInput.setPromptText("\u8bf7\u8f93\u5165\u641c\u7d22\u5f15\u64ce\u540d\u79f0");
        Label searchLabel = new Label("\u641c\u7d22\u7f51\u5740");
        this.searchInput.setText(engine.getUrl());
        this.searchInput.setPromptText("\u8bf7\u8f93\u5165\u641c\u7d22\u5f15\u64ce\u641c\u7d22\u94fe\u63a5\uff0c\u5173\u952e\u8bcd\u7528{{keyword}}\u4ee3\u66ff");
        Label stylesheetLabel = new Label("\u81ea\u5b9a\u4e49\u6837\u5f0f");
        this.stylesheetInput.setText(engine.getStylesheet());
        this.stylesheetInput.setPromptText("\u8bf7\u8f93\u5165\u6216\u9009\u62e9\u81ea\u5b9a\u4e49\u641c\u7d22\u5f15\u64ce\u7684CSS\u6837\u5f0f");
        IconButton stylesheetSelector = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u9009\u62e9", IconFont.BROWSER, null), (String[])new String[]{"btn"});
        stylesheetSelector.setOnMouseClicked(e -> {
            FileChooser chooser = new FileChooser();
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSS", new String[]{"*.css"}));
            File file = chooser.showOpenDialog((Window)App.stage());
            if (FileUtil.exist((File)file)) {
                this.stylesheetInput.setText(file.getAbsolutePath());
            }
        });
        HBox stylesheetsBox = new HBox(new Node[]{this.stylesheetInput, stylesheetSelector});
        HBox.setHgrow((Node)this.stylesheetInput, (Priority)Priority.ALWAYS);
        stylesheetsBox.setSpacing(10.0);
        this.getChildren().addAll((Object[])new Node[]{nameLabel, this.nameInput, searchLabel, this.searchInput, stylesheetLabel, stylesheetsBox});
        this.setSpacing(10.0);
    }

    public SearchEngine getResult() {
        this.engine.setName(this.nameInput.getText());
        this.engine.setUrl(this.searchInput.getText());
        this.engine.setStylesheet(this.stylesheetInput.getText());
        return this.engine;
    }
}

