/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.setting;

import com.jfoenix.controls.JFXCheckBox;
import com.unclezs.novel.analyzer.request.proxy.HttpProxy;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.framework.util.ProxyUtils;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.config.ProxyConfig;
import com.unclezs.novel.app.main.views.components.setting.SettingItem;
import com.unclezs.novel.app.main.views.components.setting.SettingItems;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySetting
extends SettingItems {
    private static final Logger log = LoggerFactory.getLogger(ProxySetting.class);
    public static final String PROXY_TEST_URL = "https://ip.900cha.com";
    public static final String PROXY_INFO_SELECTOR = ".list-unstyled";

    public ProxySetting() {
        super(LocalizedSupport.app((String)"setting.proxy"), List.of(ProxySetting.createSystemProxy(), ProxySetting.createHttpProxy()));
    }

    private static SettingItem createSystemProxy() {
        ProxyConfig proxyConfig = SettingManager.manager().getProxy();
        JFXCheckBox useSystemCheckBox = new JFXCheckBox("\u542f\u7528\u7cfb\u7edf\u4ee3\u7406");
        useSystemCheckBox.selectedProperty().bindBidirectional(proxyConfig.getUseSystem());
        useSystemCheckBox.selectedProperty().addListener(e -> ProxyUtils.setEnabledSystemProxy((boolean)useSystemCheckBox.isSelected()));
        ProxyUtils.setEnabledSystemProxy((boolean)useSystemCheckBox.isSelected());
        return new SettingItem("\u7cfb\u7edf\u4ee3\u7406", (Node)useSystemCheckBox);
    }

    private static SettingItem createHttpProxy() {
        ProxyConfig proxyConfig = SettingManager.manager().getProxy();
        JFXCheckBox httpProxyCheckBox = new JFXCheckBox(LocalizedSupport.app((String)"setting.proxy.enabled"));
        ObjectProperty<Boolean> httpProxy = proxyConfig.getHttpProxy();
        httpProxyCheckBox.selectedProperty().bindBidirectional(httpProxy);
        httpProxy.addListener(e -> ProxyConfig.initHttpProxy());
        TextField host = new TextField();
        host.setPromptText(LocalizedSupport.app((String)"setting.proxy.host"));
        host.textProperty().bindBidirectional(proxyConfig.getHost());
        proxyConfig.getHost().addListener(e -> ProxyUtils.setHttpProxyHost((String)((String)proxyConfig.getHost().get())));
        TextField port = new TextField();
        port.textProperty().bindBidirectional(proxyConfig.getPort());
        port.setPromptText(LocalizedSupport.app((String)"setting.proxy.port"));
        proxyConfig.getPort().addListener(e -> ProxyUtils.setHttpProxyPort((String)((String)proxyConfig.getPort().get())));
        TextField user = new TextField();
        user.setPromptText(LocalizedSupport.app((String)"setting.proxy.user"));
        user.textProperty().bindBidirectional(proxyConfig.getUser());
        proxyConfig.getUser().addListener(e -> ProxyUtils.setHttpProxyHost((String)((String)proxyConfig.getUser().get())));
        TextField password = new TextField();
        password.setPromptText(LocalizedSupport.app((String)"setting.proxy.password"));
        password.textProperty().bindBidirectional(proxyConfig.getPassword());
        proxyConfig.getPassword().addListener(e -> ProxyUtils.setHttpProxyHost((String)((String)proxyConfig.getPassword().get())));
        IconButton debug = (IconButton)NodeHelper.addClass((Styleable)new IconButton(LocalizedSupport.app((String)"setting.proxy.test"), IconFont.DEBUG), (String[])new String[]{"btn"});
        debug.setOnMouseClicked(e -> ProxySetting.testHttpProxy());
        IconButton getProxy = (IconButton)NodeHelper.addClass((Styleable)new IconButton(LocalizedSupport.app((String)"setting.proxy.system"), IconFont.AIRPORT), (String[])new String[]{"btn"});
        getProxy.setOnMouseClicked(e -> {
            HttpProxy systemProxy = ProxyUtils.getSystemProxy();
            if (systemProxy != HttpProxy.NO_PROXY) {
                host.setText(systemProxy.getHost());
                port.setText(String.valueOf(systemProxy.getPort()));
                Toast.success((String)LocalizedSupport.app((String)"setting.proxy.system.success"));
            } else {
                Toast.info((String)LocalizedSupport.app((String)"setting.proxy.system.error"));
            }
        });
        HBox optionsBox = new HBox(new Node[]{httpProxyCheckBox});
        optionsBox.setSpacing(10.0);
        HBox hostPortBox = new HBox(new Node[]{host, port, getProxy});
        hostPortBox.setSpacing(20.0);
        HBox userPasswordBox = new HBox(new Node[]{user, password, debug});
        userPasswordBox.setSpacing(20.0);
        VBox container = new VBox(new Node[]{optionsBox, hostPortBox, userPasswordBox});
        container.setSpacing(5.0);
        return new SettingItem(LocalizedSupport.app((String)"setting.proxy.http"), (Node)container);
    }

    private static void testHttpProxy() {
        TaskFactory.create(() -> Jsoup.connect((String)PROXY_TEST_URL).followRedirects(true).get().select(PROXY_INFO_SELECTOR).first().select("li").eachText()).onSuccess(content -> {
            StringBuilder message = new StringBuilder();
            content.forEach(str -> message.append((String)str).append("\n"));
            ModalBox.none().message(message.toString()).show();
        }).onFailed(e -> {
            log.error("\u8bf7\u6c42\u4ee3\u7406\u5931\u8d25", e);
            Toast.error((String)LocalizedSupport.app((String)"setting.proxy.invalid"));
        }).start();
    }
}

