/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.setting;

import com.jfoenix.controls.JFXCheckBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.Choosers;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.viewmodel.BackupViewModel;
import com.unclezs.novel.app.main.views.components.setting.SettingItem;
import com.unclezs.novel.app.main.views.components.setting.SettingItems;
import java.io.File;
import javafx.beans.property.ObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupSettingView
extends SettingItems
implements LocalizedSupport {
    private static final Logger log = LoggerFactory.getLogger(BackupSettingView.class);
    private final BackupViewModel viewModel = new BackupViewModel();

    public BackupSettingView() {
        super(LocalizedSupport.app((String)"setting.backup"));
        this.setItems(new Node[]{this.backupContentView(), this.webDavView()});
    }

    private JFXCheckBox createBackupContent(String name, ObjectProperty<Boolean> property) {
        JFXCheckBox checkBox = new JFXCheckBox(name);
        checkBox.selectedProperty().bindBidirectional(property);
        return checkBox;
    }

    private TextField createTextField(String name, ObjectProperty<String> property, boolean password) {
        PasswordField textField = password ? new PasswordField() : new TextField();
        textField.setPromptText(name);
        textField.textProperty().bindBidirectional(property);
        return textField;
    }

    private SettingItem backupContentView() {
        JFXCheckBox bookshelf = this.createBackupContent(this.localized("setting.backup.bookshelf"), this.viewModel.getConfig().getBookshelf());
        JFXCheckBox rule = this.createBackupContent(this.localized("setting.backup.rule"), this.viewModel.getConfig().getRule());
        JFXCheckBox audio = this.createBackupContent(this.localized("setting.backup.bookshelf.audio"), this.viewModel.getConfig().getAudio());
        JFXCheckBox searchEngine = this.createBackupContent(this.localized("setting.backup.search.engine"), this.viewModel.getConfig().getSearchEngine());
        HBox hBox = new HBox(new Node[]{bookshelf, audio, rule, searchEngine});
        hBox.setSpacing(10.0);
        return new SettingItem(this.localized("setting.backup.content"), (Node)hBox);
    }

    private SettingItem webDavView() {
        TextField url = this.createTextField(this.localized("setting.backup.webdav.server"), this.viewModel.getConfig().getUrl(), false);
        TextField username = this.createTextField(this.localized("setting.backup.webdav.username"), this.viewModel.getConfig().getUsername(), false);
        TextField password = this.createTextField(this.localized("setting.backup.webdav.password"), this.viewModel.getConfig().getPassword(), true);
        IconButton backup = (IconButton)NodeHelper.addClass((Styleable)new IconButton(this.localized("setting.backup.webdav.action.backup")), (String[])new String[]{"btn"});
        backup.setOnAction(e -> this.doSync(true));
        IconButton restore = (IconButton)NodeHelper.addClass((Styleable)new IconButton(this.localized("setting.backup.webdav.action.restore")), (String[])new String[]{"btn"});
        restore.setOnAction(e -> this.doSync(false));
        IconButton backupToFile = (IconButton)NodeHelper.addClass((Styleable)new IconButton(this.localized("setting.backup.webdav.action.export")), (String[])new String[]{"btn"});
        backupToFile.setOnAction(e -> this.exportBackup());
        IconButton restoreFromFile = (IconButton)NodeHelper.addClass((Styleable)new IconButton(this.localized("setting.backup.webdav.action.import")), (String[])new String[]{"btn"});
        restoreFromFile.setOnAction(e -> this.importBackup());
        HBox inputs = new HBox(new Node[]{url, username, password});
        inputs.setSpacing(20.0);
        HBox actions = new HBox(new Node[]{backup, restore, backupToFile, restoreFromFile});
        actions.setSpacing(10.0);
        VBox container = new VBox(new Node[]{inputs, actions});
        container.setSpacing(10.0);
        return new SettingItem(this.localized("setting.backup.webdav"), (Node)container);
    }

    private void importBackup() {
        File backupFile = Choosers.chooseFile();
        if (backupFile != null) {
            this.viewModel.restoreBackup(backupFile);
        }
    }

    private void exportBackup() {
        File folder = Choosers.chooseFolder();
        if (folder != null) {
            this.viewModel.createBackup(folder);
        }
    }

    private void doSync(boolean backup) {
        if (this.viewModel.enabledWebDav()) {
            String type = backup ? "\u5907\u4efd" : "\u6062\u590d";
            TaskFactory.create(() -> {
                if (backup) {
                    this.viewModel.backup();
                } else {
                    this.viewModel.restore();
                }
                return null;
            }).onFailed(e -> {
                String message = String.format("%s\u5931\u8d25", type);
                log.error("{}\uff1a{}", new Object[]{message, e.getMessage(), e});
                Toast.error((String)(message + ": " + e.getMessage()));
            }).onSuccess(v -> Toast.success((String)String.format("%s\u6210\u529f", type))).start();
        } else {
            Toast.error((String)this.localized("setting.backup.webdav.tip.error"));
        }
    }
}

