/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.rule;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.jfoenix.controls.JFXCheckBox;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.script.ScriptUtils;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import java.io.IOException;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javax.script.Bindings;

public class ScriptDebugBox
extends VBox {
    TextField result = new TextField();
    TextField source = new TextField();
    TextField url = new TextField();
    TextField params = new TextField();
    TextArea script = new TextArea();
    JFXCheckBox autoRequest = new JFXCheckBox("\u81ea\u52a8\u8bf7\u6c42url\u5e76\u5c06\u7ed3\u679c\u4fdd\u5b58\u4e3asource");
    TextArea console = (TextArea)NodeHelper.addClass((Styleable)new TextArea(), (String[])new String[]{"rule-debug-console"});

    public ScriptDebugBox() {
        this.console.setMaxHeight(60.0);
        this.console.setWrapText(true);
        this.console.setPromptText("\u6b64\u5904\u4e3a\u8f93\u51fa\u7ed3\u679c");
        this.setSpacing(10.0);
        this.script.setPromptText("\u5728\u6b64\u8f93\u5165\u9884\u5904\u7406\u811a\u672c");
        this.script.setMaxHeight(120.0);
        this.autoRequest.setSelected(false);
        NodeHelper.addClass((Styleable)this.autoRequest, (String[])new String[]{"disable-visual-focus"});
        this.result.setPromptText("\u8bf7\u8f93\u5165result");
        this.source.setPromptText("\u8bf7\u8f93\u5165source");
        this.url.setPromptText("\u8bf7\u8f93\u5165url");
        this.params.setPromptText("\u8bf7\u8f93\u5165params\u7684json");
        IconButton run = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u8fd0\u884c", IconFont.RUN), (String[])new String[]{"btn"});
        IconButton copy = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u590d\u5236\u8f6c\u4e49\u540e\u7684\u811a\u672c", IconFont.COPY), (String[])new String[]{"btn"});
        copy.setOnAction(e -> this.copyScript());
        run.setOnAction(e -> this.run());
        HBox actions = new HBox(new Node[]{copy, run});
        actions.setAlignment(Pos.CENTER_RIGHT);
        actions.setSpacing(10.0);
        this.getChildren().setAll((Object[])new Node[]{this.autoRequest, this.result, this.source, this.url, this.params, this.script, this.console, actions});
    }

    private void run() {
        if (StringUtils.isBlank((CharSequence)this.script.getText())) {
            Toast.error((StackPane)((StackPane)this.getParent()), (String)"\u8bf7\u5148\u8f93\u5165\u811a\u672c");
            return;
        }
        TaskFactory.create(() -> {
            StringBuilder ret = new StringBuilder();
            ScriptContext.put((String)"result", (Object)this.result.getText());
            ScriptContext.put((String)"url", (Object)this.url.getText());
            ScriptContext.put((String)"source", (Object)this.source.getText());
            if (StringUtils.isNotBlank((CharSequence)this.params.getText())) {
                ScriptContext.put((String)"params", (Object)GsonUtils.parse((String)this.params.getText(), RequestParams.class));
            }
            if (this.autoRequest.isSelected()) {
                this.autoRequest(ret);
            }
            String executeRet = ScriptUtils.execute((String)this.script.getText(), (Bindings)ScriptContext.current());
            ret.append(executeRet);
            ScriptContext.remove();
            return ret.toString();
        }).onSuccess(arg_0 -> ((TextArea)this.console).setText(arg_0)).onFailed(err -> {
            this.console.setText(ExceptionUtil.stacktraceToString((Throwable)err));
            Toast.error((StackPane)((StackPane)this.getParent()), (String)"\u6267\u884c\u5931\u8d25");
        }).onFinally(ScriptContext::remove).start();
    }

    private void autoRequest(StringBuilder ret) throws IOException {
        if (UrlUtils.isHttpUrl((String)this.url.getText())) {
            RequestParams requestParams = RequestParams.create((String)this.url.getText());
            requestParams.setDynamic(Boolean.valueOf(true));
            String content = Http.content((RequestParams)requestParams);
            ScriptContext.put((String)"source", (Object)content);
            Executor.runFx(() -> this.source.setText(content));
        } else {
            ret.append("\u8b66\u544a\uff1a\u5fc5\u987b\u586b\u5199url\u624d\u53ef\u81ea\u52a8\u8bf7\u6c42");
        }
    }

    private void copyScript() {
        if (StringUtils.isBlank((CharSequence)this.script.getText())) {
            Toast.error((StackPane)((StackPane)this.getParent()), (String)"\u8bf7\u5148\u8f93\u5165\u811a\u672c");
            return;
        }
        DesktopUtils.copy((String)StringUtils.removeQuote((String)GsonUtils.toJson((Object)this.script.getText())));
        Toast.success((StackPane)((StackPane)this.getParent()), (String)"\u590d\u5236\u6210\u529f");
    }
}

