/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.rule;

import com.unclezs.novel.app.framework.collection.SimpleObservableList;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.views.components.rule.RuleItem;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

@DefaultProperty(value="items")
public class RuleItems
extends VBox {
    private final List<RuleItem> items = new SimpleObservableList<RuleItem>(){

        public void onAdd(RuleItem item) {
            RuleItems.this.getChildren().add((Object)item);
        }

        public void onRemove(RuleItem item) {
            RuleItems.this.getChildren().remove((Object)item);
        }
    };
    private final HBox titleBox = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"title-box"});
    private String title;
    private boolean debug;
    private EventHandler<? super MouseEvent> onDebug;

    public RuleItems() {
        this.getStyleClass().addAll((Object[])new String[]{"items", "no-name"});
    }

    public void setTitle(String title) {
        this.title = title;
        this.addTitleBox();
        this.titleBox.getChildren().add(0, (Object)((Node)NodeHelper.addClass((Styleable)new Label(title), (String[])new String[]{"title"})));
        this.getStyleClass().remove((Object)"no-name");
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (debug) {
            this.addTitleBox();
            IconButton debugButton = new IconButton(IconFont.DEBUG, "\u8c03\u8bd5");
            debugButton.setOnMouseClicked(e -> {
                if (this.onDebug != null) {
                    this.onDebug.handle(e);
                }
            });
            this.titleBox.getChildren().add((Object)debugButton);
        }
    }

    private void addTitleBox() {
        if (this.titleBox.getChildren().isEmpty()) {
            this.getChildren().add(0, (Object)this.titleBox);
        }
    }

    public void addItem(int index, RuleItem item) {
        this.getChildren().add(index + 1, (Object)item);
    }

    public void removeItem(RuleItem item) {
        this.getChildren().remove((Object)item);
    }

    public List<RuleItem> getItems() {
        return this.items;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public EventHandler<? super MouseEvent> getOnDebug() {
        return this.onDebug;
    }

    public void setOnDebug(EventHandler<? super MouseEvent> onDebug) {
        this.onDebug = onDebug;
    }
}

