/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.rule;

import com.jfoenix.controls.JFXCheckBox;
import com.unclezs.novel.analyzer.request.MediaType;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.views.components.rule.RuleItem;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class ParamsEditor
extends VBox {
    public ParamsEditor(RequestParams params) {
        NodeHelper.addClass((Styleable)this, (String[])new String[]{"params-editor"});
        JFXCheckBox dynamicCheckbox = new JFXCheckBox();
        dynamicCheckbox.setSelected(Boolean.TRUE.equals(params.getDynamic()));
        ((CheckBox)this.addItem("\u52a8\u6001\u7f51\u9875", dynamicCheckbox)).selectedProperty().addListener((ov, o, n) -> params.setDynamic(n));
        ComboBox methodBox = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{"GET", "POST"}));
        methodBox.setValue((Object)params.getMethod());
        methodBox.setEditable(true);
        this.addItem("\u8bf7\u6c42\u65b9\u6cd5", methodBox).valueProperty().addListener((ov, o, n) -> params.setMethod(n));
        ComboBox charsetBox = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{"UTF-8", "GBK", "GB2312"}));
        charsetBox.setValue((Object)params.getCharset());
        charsetBox.setEditable(true);
        this.addItem("\u7f16\u7801\u683c\u5f0f", charsetBox).valueProperty().addListener((ov, o, n) -> params.setCharset(n));
        ComboBox mediaTypeBox = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{MediaType.FORM.getMediaType(), MediaType.JSON.getMediaType()}));
        mediaTypeBox.setValue((Object)params.getMediaType());
        mediaTypeBox.setEditable(true);
        this.addItem("\u5a92\u4f53\u7c7b\u578b", mediaTypeBox).valueProperty().addListener((ov, o, n) -> params.setMediaType(n));
        TextField urlParamsField = new TextField(params.getUrlParams());
        urlParamsField.setPromptText("\u683c\u5f0f\u4e3a  key=value&key=value");
        this.addItem("URL\u53c2\u6570", urlParamsField).focusedProperty().addListener((ov, o, n) -> {
            if (Boolean.FALSE.equals(n)) {
                params.setUrlParams(urlParamsField.getText());
            }
        });
        TextArea headerArea = new TextArea();
        headerArea.setPromptText("\u683c\u5f0f\u4e3a  key: value \uff0c\u4e00\u884c\u4e00\u4e2a");
        headerArea.setText(params.getHeaderString());
        this.addItem("\u8bf7\u6c42\u5934", headerArea).focusedProperty().addListener((ov, o, n) -> {
            if (Boolean.FALSE.equals(n)) {
                params.setHeaderString(StringUtils.nullToEmpty((CharSequence)headerArea.getText()));
            }
        });
        TextField bodyField = new TextField(params.getBody());
        bodyField.setPromptText("\u8bf7\u6c42\u4f53\uff0c\u683c\u5f0f\u4e3a  key=value&key=value");
        this.addItem("\u8bf7\u6c42\u4f53", bodyField).focusedProperty().addListener(e -> {
            if (!bodyField.isFocused()) {
                params.setBody(bodyField.getText());
            }
        });
        TextField script = new TextField(params.getScript());
        script.setPromptText("\u9884\u5904\u7406\u811a\u672c\uff0c\u5728\u8bf7\u6c42\u5b8c\u6210\u540e\u5904\u7406\u6e90\u7801\uff0c\u6700\u7ec8\u8fd4\u56de\u6e90\u7801");
        this.addItem("\u9884\u5904\u7406\u811a\u672c", script).focusedProperty().addListener(e -> {
            if (!script.isFocused()) {
                params.setScript(script.getText());
            }
        });
        TextField delay = new TextField(String.valueOf(params.getDynamicDelayTime()));
        delay.setPromptText("\u52a8\u6001\u7f51\u9875\u811a\u672c\u5ef6\u8fdf\u6267\u884c\u65f6\u95f4\u6beb\u79d2\u6570");
        this.addItem("\u811a\u672c\u5ef6\u8fdf", delay).focusedProperty().addListener(e -> {
            if (!delay.isFocused()) {
                try {
                    params.setDynamicDelayTime(Long.valueOf(Long.parseLong(delay.getText())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private <T extends Node> T addItem(String name, T content) {
        RuleItem item = new RuleItem();
        item.setName(name);
        item.getContent().add(content);
        this.getChildren().add((Object)item);
        return content;
    }
}

