/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.rule;

import cn.hutool.core.text.CharSequenceUtil;
import com.unclezs.novel.analyzer.core.helper.RuleHelper;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.core.rule.ReplaceRule;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.SerializationUtils;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.NodeHelper;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class CommonRuleEditor
extends VBox {
    private final TextArea editor = new TextArea();
    private final ComboBox<String> types;
    private final TextField ruleField;
    private CommonRule rule;
    private HBox pagesBox;

    public CommonRuleEditor() {
        NodeHelper.addClass((Styleable)this, (String[])new String[]{"common-rule-editor"});
        this.editor.setWrapText(true);
        TextField key = new TextField();
        HBox keyBox = this.createActionBox("\u66ff\u6362\u6587\u5b57\u6216\u6b63\u5219", (Node)key);
        key.setPromptText("\u8bf7\u8f93\u5165\u66ff\u6362\u6587\u5b57\uff0c\u6b63\u5219\u4ee5regex:\u5f00\u5934");
        TextField value = new TextField();
        value.setPromptText("\u8bf7\u8f93\u5165\u66ff\u6362\u4e3a\u7684\u6587\u5b57\uff0c\u6b63\u5219\u4ee5$\u7ec4\u53f7\u66ff\u6362");
        HBox valueBox = this.createActionBox("\u66ff\u6362\u6587\u5b57\u6216\u6a21\u677f", (Node)value);
        TextField script = new TextField();
        HBox scriptBox = this.createActionBox("\u7ed3\u679c\u9884\u5904\u7406\u811a\u672c", (Node)script);
        script.setPromptText("\u5904\u7406\u5339\u914d\u540e\u7ed3\u679c\u7684\u811a\u672c");
        this.ruleField = new TextField();
        HBox ruleBox = this.createActionBox("\u5339\u914d\u5668\u89c4\u5219\u5185\u5bb9", (Node)this.ruleField);
        this.ruleField.setPromptText("\u5904\u7406\u5339\u914d\u540e\u7ed3\u679c\u7684\u811a\u672c");
        this.ruleField.focusedProperty().addListener(e -> {
            if (!this.ruleField.isFocused()) {
                this.rule().setRule(CharSequenceUtil.emptyToNull((CharSequence)this.ruleField.getText()));
                this.update();
            }
        });
        this.types = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{"xpath", "css", "json", "regex"}));
        HBox typeBox = this.createActionBox("\u5339\u914d\u5668\u89c4\u5219\u7c7b\u578b", (Node)this.types);
        this.types.valueProperty().addListener(e -> {
            this.rule().setType((String)this.types.getValue());
            this.update();
        });
        IconButton add = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u6dfb\u52a0\u66ff\u6362\u89c4\u5219", IconFont.PLUS, null), (String[])new String[]{"btn"});
        IconButton addScript = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u66f4\u65b0\u9884\u5904\u7406\u811a\u672c", IconFont.CODE, null), (String[])new String[]{"btn"});
        IconButton reset = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u91cd\u7f6e\u89c4\u5219", IconFont.DELETE, null), (String[])new String[]{"btn"});
        add.setOnMouseClicked(e -> {
            this.rule().addReplaceRule(new ReplaceRule(key.getText(), value.getText()));
            this.update();
        });
        addScript.setOnAction(e -> {
            this.rule().setScript(script.getText());
            this.update();
        });
        reset.setOnAction(e -> this.setRule(new CommonRule()));
        HBox buttonBox = new HBox(new Node[]{reset, add, addScript});
        buttonBox.setSpacing(10.0);
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().addAll((Object[])new Node[]{this.editor, typeBox, ruleBox, keyBox, valueBox, scriptBox, buttonBox});
        this.setSpacing(10.0);
    }

    private HBox createActionBox(String title, Node item) {
        Label titleLabel = (Label)NodeHelper.addClass((Styleable)new Label(title.concat(":")), (String[])new String[]{"title-label"});
        NodeHelper.addClass((Styleable)item, (String[])new String[]{"action-item"});
        HBox.setHgrow((Node)item, (Priority)Priority.ALWAYS);
        return (HBox)NodeHelper.addClass((Styleable)new HBox(new Node[]{titleLabel, item}), (String[])new String[]{"action-box"});
    }

    public void setShowPage(boolean show) {
        if (this.pagesBox == null) {
            ComboBox pages = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{"search", "detail"}));
            this.pagesBox = this.createActionBox("\u89c4\u5219\u5bf9\u5e94\u7684\u9875\u9762", (Node)pages);
            pages.valueProperty().addListener(e -> {
                this.rule().setPage((String)pages.getValue());
                this.update();
            });
        }
        this.getChildren().remove((Object)this.pagesBox);
        if (show) {
            this.getChildren().add(1, (Object)this.pagesBox);
        }
    }

    public void update() {
        this.editor.setText(GsonUtils.PRETTY.toJson((Object)this.rule));
    }

    public CommonRule getRule() {
        return (CommonRule)RuleHelper.parseRule((String)this.editor.getText(), CommonRule.class);
    }

    public void setRule(CommonRule rule) {
        this.rule = (CommonRule)SerializationUtils.deepClone((Object)rule);
        this.types.setValue((Object)rule.getType());
        this.ruleField.setText(rule.getRule());
        this.update();
    }

    public String getJson() {
        return this.editor.getText();
    }

    private CommonRule rule() {
        return this.rule;
    }
}

