/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.app.framework.components.cell.BaseListCell;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.NodeHelper;
import java.util.function.Function;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class TocListCell
extends BaseListCell<Chapter> {
    public static final String DEFAULT_STYLE_CLASS = "toc-list-cell";
    private final Icon icon = new Icon((Object)IconFont.BOOKMARK);
    private final Icon cached = new Icon((Object)IconFont.ENABLED);
    private final Label label = new Label();
    private final HBox cell = new HBox();
    private Function<Integer, Boolean> cacheStateGetter;

    public TocListCell() {
        this.label.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.cacheStateGetter = index -> ((Chapter)this.getItem()).getContent() != null;
    }

    public TocListCell(Function<Integer, Boolean> cacheStateGetter) {
        this();
        this.cacheStateGetter = cacheStateGetter;
    }

    protected void updateItem(Chapter item) {
        NodeHelper.addClass((Styleable)this, (String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setGraphic((Node)this.cell);
        this.label.setGraphic((Node)this.icon);
        this.label.setText(item.getName());
        this.cell.getChildren().setAll((Object[])new Node[]{this.label});
        if (Boolean.TRUE.equals(this.cacheStateGetter.apply(this.getIndex()))) {
            this.cell.getChildren().add((Object)this.cached);
        }
    }
}

