/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import com.unclezs.novel.app.framework.components.Tag;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.layout.HBox;

public class TagsTableCell<S>
extends TableCell<S, String> {
    private final List<Tag> tags = new ArrayList<Tag>();
    private final HBox box = new HBox();

    public TagsTableCell() {
        this.box.setSpacing(3.0);
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            String[] tagsText = item.split(",");
            this.box.getChildren().clear();
            for (int i = 0; i < tagsText.length; ++i) {
                if (this.tags.size() < i + 1) {
                    this.tags.add(new Tag(tagsText[i]));
                } else {
                    this.tags.get(i).setText(tagsText[i]);
                }
                this.box.getChildren().add((Object)((Node)this.tags.get(i)));
            }
            this.setGraphic((Node)this.box);
        }
    }
}

