/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import com.jfoenix.controls.JFXProgressBar;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.core.spider.SpiderWrapper;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class ProgressBarTableCell
extends TableCell<SpiderWrapper, SpiderWrapper> {
    private final JFXProgressBar progressBar = new JFXProgressBar();
    private final Label progressText;
    private final Label state;
    private final Label error;
    private final VBox cell;
    private final InvalidationListener stateListener;
    private SpiderWrapper item;

    public ProgressBarTableCell() {
        this.progressBar.setPrefWidth(Double.MAX_VALUE);
        this.progressText = new Label();
        HBox progressTextBox = new HBox(new Node[]{this.progressText});
        progressTextBox.setAlignment(Pos.CENTER_RIGHT);
        progressTextBox.setPrefWidth(90.0);
        this.state = new Label("\u7b49\u5f85\u4e2d...");
        this.state.setPrefWidth(90.0);
        this.error = new Label();
        BorderPane.setAlignment((Node)this.error, (Pos)Pos.CENTER);
        BorderPane box = new BorderPane((Node)this.error, null, (Node)progressTextBox, null, (Node)this.state);
        NodeHelper.addClass((Styleable)box, (String[])new String[]{"progress-info-box"});
        this.cell = new VBox(new Node[]{this.progressBar, box});
        this.cell.setAlignment(Pos.CENTER_LEFT);
        NodeHelper.addClass((Styleable)this.cell, (String[])new String[]{"progress-cell"});
        this.stateListener = e -> this.setState();
    }

    public void updateItem(SpiderWrapper item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            if (this.item != null) {
                this.item.getState().removeListener(this.stateListener);
            }
            this.item = item;
            this.setState();
            this.item.getState().addListener(this.stateListener);
            this.progressBar.progressProperty().unbind();
            this.error.textProperty().unbind();
            this.progressText.textProperty().unbind();
            this.progressBar.progressProperty().bind(item.getProgress());
            this.progressText.textProperty().bind(item.getProgressText());
            this.error.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if ((Integer)item.getErrorCount().get() > 0) {
                    return String.format("%d\u5931\u8d25", item.getErrorCount().get());
                }
                return null;
            }, (Observable[])new Observable[]{item.getErrorCount()}));
            this.setGraphic((Node)this.cell);
        }
    }

    private void setState() {
        Integer spiderState = (Integer)this.item.getState().get();
        switch (spiderState) {
            case 2: {
                this.state.setText("\u4e0b\u8f7d\u4e2d...");
                break;
            }
            case 3: {
                this.state.setText("\u6682\u505c\u4e2d...");
                break;
            }
            case 4: {
                this.state.setText("\u7b49\u5f85\u624b\u52a8\u91cd\u8bd5...");
                break;
            }
            case 1001: {
                this.state.setText("\u7b49\u5f85\u4e2d...");
                break;
            }
            case 5: {
                this.state.setText("\u8f6c\u7801\u4e2d...");
                break;
            }
        }
    }
}

