/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.core.spider.SpiderWrapper;
import com.unclezs.novel.app.main.views.home.DownloadManagerView;
import java.io.File;
import javafx.beans.InvalidationListener;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;

public class DownloadActionTableCell
extends TableCell<SpiderWrapper, SpiderWrapper> {
    private final HBox box;
    private final Icon start;
    private final Icon pause;
    private final Icon stop;
    private final Icon retry;
    private final Icon folder;
    private final Icon save;
    private final InvalidationListener stateListener;
    private SpiderWrapper item;

    public DownloadActionTableCell() {
        NodeHelper.addClass((Styleable)this, (String[])new String[]{"download-action-cell"});
        this.setGraphic(null);
        this.start = (Icon)NodeHelper.addClass((Styleable)new Icon((Object)IconFont.RUN), (String[])new String[0]);
        this.start.setTooltip(new Tooltip("\u5f00\u59cb"));
        this.pause = (Icon)NodeHelper.addClass((Styleable)new Icon((Object)IconFont.PAUSE_RUN), (String[])new String[0]);
        this.pause.setTooltip(new Tooltip("\u6682\u505c"));
        this.retry = (Icon)NodeHelper.addClass((Styleable)new Icon((Object)IconFont.RETRY), (String[])new String[0]);
        this.retry.setTooltip(new Tooltip("\u91cd\u8bd5\u5931\u8d25\u7ae0\u8282"));
        this.save = (Icon)NodeHelper.addClass((Styleable)new Icon((Object)IconFont.SAVE), (String[])new String[0]);
        this.save.setTooltip(new Tooltip("\u5ffd\u7565\u9519\u8bef"));
        this.stop = (Icon)NodeHelper.addClass((Styleable)new Icon((Object)IconFont.STOP), (String[])new String[]{"delete"});
        this.stop.setTooltip(new Tooltip("\u505c\u6b62"));
        this.folder = (Icon)NodeHelper.addClass((Styleable)new Icon((Object)IconFont.FOLDER), (String[])new String[0]);
        this.folder.setTooltip(new Tooltip("\u6587\u4ef6\u5939"));
        this.box = (HBox)NodeHelper.addClass((Styleable)new HBox(new Node[]{this.start, this.stop, this.folder}), (String[])new String[]{"action-cell", "download-action"});
        this.start.setOnMouseClicked(event -> {
            this.item.runTask();
            Toast.success((String)"\u542f\u52a8");
        });
        this.pause.setOnMouseClicked(e -> {
            this.item.pause();
            Toast.success((String)"\u6682\u505c");
        });
        this.retry.setOnMouseClicked(e -> this.item.retry());
        this.save.setOnMouseClicked(e -> ModalBox.confirm(confirmSave -> {
            if (Boolean.TRUE.equals(confirmSave)) {
                this.item.save();
            }
        }).title("\u786e\u5b9a\u5ffd\u7565\u9519\u8bef\u5417").message("\u5ffd\u7565\u9519\u8bef\u53ef\u80fd\u51fa\u73b0\u7ae0\u8282\u5185\u5bb9\u4e0d\u5b8c\u6574\u7684\u60c5\u51b5").show());
        this.stop.setOnMouseClicked(event -> {
            String savePath = this.item.getSpider().getSavePath();
            String name = StringUtils.removeInvalidSymbol((String)this.item.getName());
            this.item.stop();
            this.getTableView().getItems().remove((Object)this.item);
            if (StringUtils.isNotBlank((CharSequence)savePath) && StringUtils.isNotBlank((CharSequence)name)) {
                FileUtil.del((File)FileUtil.file((String)savePath, (String)name));
                FileUtil.del((File)FileUtil.file((String)savePath, (String)(name + "_Ebook")));
            }
            FileUtil.del((File)FileUtil.file((File)DownloadManagerView.TMP_DIR, (String)this.item.getId()));
        });
        this.folder.setOnMouseClicked(e -> DesktopUtils.openDir((File)new File(this.item.getSpider().getSavePath())));
        this.stateListener = e -> this.setState();
    }

    protected void updateItem(SpiderWrapper item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            if (this.item != null) {
                this.item.getState().removeListener(this.stateListener);
            }
            this.item = item;
            this.setState();
            item.getState().addListener(this.stateListener);
            this.setGraphic((Node)this.box);
        }
    }

    private void setState() {
        Integer state = (Integer)this.item.getState().get();
        this.pause.setDisable(false);
        switch (state) {
            case 4: {
                this.box.getChildren().setAll((Object[])new Node[]{this.retry, this.stop, this.folder, this.save});
                break;
            }
            case 2: 
            case 1001: {
                this.box.getChildren().setAll((Object[])new Node[]{this.pause, this.stop, this.folder});
                break;
            }
            case 5: {
                this.box.getChildren().setAll((Object[])new Node[]{this.pause, this.stop, this.folder});
                this.pause.setDisable(true);
                break;
            }
            default: {
                this.box.getChildren().setAll((Object[])new Node[]{this.start, this.stop, this.folder});
            }
        }
    }
}

