/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import com.jfoenix.controls.JFXCheckBox;
import com.unclezs.novel.app.framework.components.cell.BaseListCell;
import com.unclezs.novel.app.main.model.ChapterProperty;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;

public class ChapterListCell
extends BaseListCell<ChapterProperty> {
    public static final String LOAD_MORE = "\u52a0\u8f7d\u66f4\u591a";
    private final CheckBox checkBox = new JFXCheckBox();
    private ObservableValue<Boolean> booleanProperty;

    public ChapterListCell() {
        this.checkBox.setOnAction(e -> {
            if (this.getListView().getUserData() == null) {
                this.getListView().setUserData((Object)this.checkBox);
                this.getListView().getSelectionModel().getSelectedItems().forEach(selectedItem -> {
                    if (!Objects.equals(this.checkBox.isSelected(), selectedItem.isSelected())) {
                        selectedItem.setSelected(this.checkBox.isSelected());
                    }
                });
                this.getListView().setUserData(null);
            }
        });
    }

    protected void updateItem(ChapterProperty item) {
        if (item.getChapter() == null) {
            this.setGraphic(null);
            this.setText(LOAD_MORE);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setGraphic((Node)this.checkBox);
            this.setText(item.getChapter().getName());
            this.setAlignment(Pos.CENTER_LEFT);
        }
        if (this.booleanProperty != null) {
            this.checkBox.selectedProperty().unbindBidirectional((Property)((BooleanProperty)this.booleanProperty));
        }
        this.booleanProperty = item.selectedProperty();
        if (this.booleanProperty != null) {
            this.checkBox.selectedProperty().bindBidirectional((Property)((BooleanProperty)this.booleanProperty));
        }
    }
}

