/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import cn.hutool.core.text.CharSequenceUtil;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.app.framework.components.LoadingImageView;
import com.unclezs.novel.app.framework.components.Tag;
import com.unclezs.novel.app.framework.components.cell.BaseListCell;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class BookListCell
extends BaseListCell<Novel>
implements LocalizedSupport {
    public static final Image NO_COVER = new Image(ResourceUtils.externalForm((String)"assets/images/no-cover.jpg"), true);
    private final HBox cell = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"cell"});
    private final Label title = (Label)NodeHelper.addClass((Styleable)new Label(), (String[])new String[]{"title"});
    private final Label author = new Label("", (Node)new Label(this.localized("novel.author").concat(":")));
    private final Label desc = new Label("", (Node)new Label(this.localized("novel.desc").concat(":")));
    private final Label latestChapter = new Label("", (Node)new Label(this.localized("novel.chapter.latest").concat(":")));
    private final HBox tags = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"tags"});
    private final LoadingImageView cover = new LoadingImageView(NO_COVER, 65.0, 90.0);

    public BookListCell(ListView<Novel> listView) {
        this.desc.prefWidthProperty().bind((ObservableValue)listView.widthProperty().subtract(100));
        this.cell.getChildren().addAll((Object[])new Node[]{this.cover, new VBox(new Node[]{this.title, this.author, this.latestChapter, this.desc, this.tags})});
    }

    protected void updateItem(Novel novel) {
        this.init(novel);
        if (this.getGraphic() == null) {
            this.setGraphic((Node)this.cell);
        }
    }

    private void init(Novel novel) {
        this.cover.setImage(novel.getCoverUrl());
        String unknown = this.localized("unknown");
        this.title.setText(CharSequenceUtil.blankToDefault((CharSequence)novel.getTitle(), (String)unknown).replace("\n", ""));
        this.author.setText(CharSequenceUtil.blankToDefault((CharSequence)novel.getAuthor(), (String)unknown).replace("\n", ""));
        this.desc.setText(CharSequenceUtil.blankToDefault((CharSequence)novel.getIntroduce(), (String)this.localized("none")).replace("\n", ""));
        this.latestChapter.setText(CharSequenceUtil.blankToDefault((CharSequence)novel.getLatestChapterName(), (String)unknown).replace("\n", ""));
        ArrayList<Tag> novelTags = new ArrayList<Tag>();
        if (CharSequenceUtil.isNotBlank((CharSequence)novel.getBroadcast())) {
            novelTags.add(new Tag(novel.getBroadcast()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)novel.getState())) {
            novelTags.add(new Tag(novel.getState()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)novel.getCategory())) {
            novelTags.add(new Tag(novel.getCategory()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)novel.getWordCount())) {
            novelTags.add(new Tag(novel.getWordCount()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)novel.getUpdateTime())) {
            novelTags.add(new Tag(novel.getUpdateTime()));
        }
        this.tags.getChildren().setAll(novelTags);
    }
}

