/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components.cell;

import cn.hutool.core.text.CharSequenceUtil;
import com.unclezs.novel.app.framework.components.LoadingImageView;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.db.beans.AudioBook;
import com.unclezs.novel.app.main.views.components.cell.BookListCell;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class AudioBookListCell
extends ListCell<AudioBook>
implements LocalizedSupport {
    private final HBox cell = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"cell"});
    private final Label title = (Label)NodeHelper.addClass((Styleable)new Label(), (String[])new String[]{"title"});
    private final Label author = new Label("", (Node)new Label(this.localized("novel.author").concat(":")));
    private final Label broadcast = new Label("", (Node)new Label(this.localized("novel.speaker").concat(":")));
    private final Label latestChapter = new Label("", (Node)new Label("\u4e0a\u6b21\u542c\u5230".concat(":")));
    private final HBox tags = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"tags"});
    private final LoadingImageView cover = new LoadingImageView(BookListCell.NO_COVER, 65.0, 90.0);
    private final ContextMenu contextMenu;
    private final Consumer<AudioBook> onPrimaryClick;

    public AudioBookListCell(ContextMenu contextMenu, Consumer<AudioBook> onPrimaryClick) {
        VBox infoBox = new VBox(new Node[]{this.title, this.author, this.broadcast, this.latestChapter, this.tags});
        infoBox.setSpacing(4.0);
        infoBox.setAlignment(Pos.CENTER_LEFT);
        this.cell.getChildren().addAll((Object[])new Node[]{this.cover, infoBox});
        this.contextMenu = contextMenu;
        this.onPrimaryClick = onPrimaryClick;
    }

    protected void updateItem(AudioBook book, boolean empty) {
        super.updateItem((Object)book, empty);
        if (book == null || empty) {
            this.setGraphic(null);
            this.setText(null);
            this.setContextMenu(null);
            this.setOnMouseClicked(null);
        } else {
            this.init(book);
            if (this.getGraphic() == null) {
                this.setGraphic((Node)this.cell);
            }
            EventUtils.setOnMousePrimaryClick((Node)this, e -> this.onPrimaryClick.accept(book));
            this.setContextMenu(this.contextMenu);
        }
    }

    private void init(AudioBook book) {
        this.cover.setImage(book.getCover());
        String unknown = this.localized("unknown");
        this.title.setText(CharSequenceUtil.blankToDefault((CharSequence)book.getName(), (String)unknown));
        this.author.setText(CharSequenceUtil.blankToDefault((CharSequence)book.getAuthor(), (String)unknown));
        this.latestChapter.setText(CharSequenceUtil.blankToDefault((CharSequence)book.getCurrentChapterName(), (String)unknown));
        this.broadcast.setText(CharSequenceUtil.blankToDefault((CharSequence)book.getBroadcast(), (String)unknown));
        ArrayList novelTags = new ArrayList();
        this.tags.getChildren().setAll(novelTags);
    }
}

