/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components;

import com.jfoenix.controls.JFXSpinner;
import com.unclezs.novel.app.framework.components.LoadingImageView;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.views.components.cell.BookListCell;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;

public class BookNode
extends StackPane {
    public static final String SHOW_TITLE_STYLE_CSS = "show-title";
    private final LoadingImageView cover = new LoadingImageView(BookListCell.NO_COVER, 95.0, 120.0);
    private final Label title = (Label)NodeHelper.addClass((Styleable)new Label(), (String[])new String[]{"title"});
    private final Label tip = (Label)NodeHelper.addClass((Styleable)new Label("\u53d1\u73b0\u66f4\u65b0"), (String[])new String[]{"tip"});
    private final Book book;
    private final StackPane container;
    private JFXSpinner updating;

    public BookNode(Book book) {
        this.book = book;
        NodeHelper.addClass((Styleable)this, (String[])new String[]{"book-node"});
        StackPane.setAlignment((Node)this.title, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setAlignment((Node)this.tip, (Pos)Pos.TOP_RIGHT);
        this.cover.setImage(book.getCover());
        this.title.setText(book.getName());
        this.tip.setVisible(book.isUpdate());
        this.container = (StackPane)NodeHelper.addClass((Styleable)new StackPane(new Node[]{this.cover, this.title, this.tip}), (String[])new String[]{"book-node-container"});
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.showTitle((Boolean)SettingManager.manager().getBookShelf().getAlwaysShowBookTitle().get());
    }

    public void setTitle(String title) {
        this.book.setName(title);
        this.title.setText(title);
    }

    public void setCover(String cover) {
        this.book.setCover(cover);
        this.cover.setImage(cover);
    }

    public void setUpdate(boolean update) {
        this.tip.setVisible(update);
        this.book.setUpdate(update);
    }

    public void setUpdateTaskState(boolean running) {
        if (this.updating == null) {
            this.updating = new JFXSpinner();
            this.updating.setRadius(5.0);
            StackPane.setAlignment((Node)this.updating, (Pos)Pos.TOP_LEFT);
            this.container.getChildren().add((Object)this.updating);
        }
        this.updating.setVisible(running);
    }

    public void showTitle(boolean show) {
        this.title.getStyleClass().remove((Object)SHOW_TITLE_STYLE_CSS);
        if (show) {
            this.title.getStyleClass().add((Object)SHOW_TITLE_STYLE_CSS);
        }
    }

    public Book getBook() {
        return this.book;
    }
}

