/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.components;

import cn.hutool.core.text.CharSequenceUtil;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.components.LoadingImageView;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Tag;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.Choosers;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.util.BookHelper;
import com.unclezs.novel.app.main.views.components.cell.BookListCell;
import java.io.File;
import java.util.function.Consumer;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class BookDetailModal
extends VBox
implements LocalizedSupport {
    public static final String DEFAULT_STYLE_CLASS = "book-detail";
    private final boolean editable;
    private final Novel novel;
    private final boolean audio;
    private IconButton bookshelf;
    private IconButton analysis;
    private IconButton download;
    private IconButton toc;
    private ModalBox containerModal;

    public BookDetailModal(Novel novel, boolean audio, boolean editable) {
        this.audio = audio;
        this.novel = novel;
        this.editable = editable;
        NodeHelper.addClass((Styleable)this, (String[])new String[]{DEFAULT_STYLE_CLASS});
        LoadingImageView cover = new LoadingImageView(BookListCell.NO_COVER, 100.0, 140.0);
        cover.setImage(novel.getCoverUrl());
        if (editable) {
            cover.setOnMouseClicked(e -> {
                File file = Choosers.chooseImage((String)"\u5c0f\u8bf4\u5c01\u9762");
                if (file != null) {
                    novel.setCoverUrl(file.getAbsolutePath());
                    cover.setImage(novel.getCoverUrl());
                }
            });
        }
        HBox title = this.createItem(null, novel.getTitle(), Type.EDITABLE, arg_0 -> ((Novel)novel).setTitle(arg_0), "title");
        HBox author = this.createItem(this.localized("novel.author"), novel.getAuthor(), Type.EDITABLE, arg_0 -> ((Novel)novel).setAuthor(arg_0), new String[0]);
        HBox site = this.createItem("\u6765\u6e90", novel.getUrl(), Type.LINK, new String[0]);
        HBox wordCount = this.createItem("\u5b57\u6570", novel.getWordCount(), new String[0]);
        HBox category = this.createItem("\u5206\u7c7b", novel.getCategory(), Type.EDITABLE, arg_0 -> ((Novel)novel).setCategory(arg_0), new String[0]);
        HBox state = this.createItem("\u72b6\u6001", novel.getState(), Type.TAG, new String[0]);
        HBox updateTime = this.createItem("\u66f4\u65b0\u65f6\u95f4", novel.getUpdateTime(), Type.EDITABLE, arg_0 -> ((Novel)novel).setUpdateTime(arg_0), new String[0]);
        HBox latestChapter = this.createItem(this.localized("novel.chapter.latest"), novel.getLatestChapterName(), Type.EDITABLE, arg_0 -> ((Novel)novel).setLatestChapterName(arg_0), new String[0]);
        HBox desc = this.createItem(null, CharSequenceUtil.blankToDefault((CharSequence)novel.getIntroduce(), (String)"\u6682\u65e0\u7b80\u4ecb"), "desc");
        VBox detailContainer = new VBox(new Node[]{title, author});
        if (StringUtils.isNotBlank((CharSequence)novel.getBroadcast())) {
            HBox broadcast = this.createItem(this.localized("novel.speaker"), novel.getBroadcast(), Type.EDITABLE, arg_0 -> ((Novel)novel).setBroadcast(arg_0), new String[0]);
            detailContainer.getChildren().add((Object)broadcast);
        }
        detailContainer.getChildren().addAll((Object[])new Node[]{site, latestChapter, wordCount, category, state, updateTime});
        NodeHelper.addClass((Styleable)detailContainer, (String[])new String[]{"info"});
        if (audio) {
            detailContainer.getChildren().remove((Object)wordCount);
        }
        HBox container = new HBox(new Node[]{detailContainer, cover});
        this.getChildren().addAll((Object[])new Node[]{container, desc});
    }

    public BookDetailModal(Novel novel) {
        this(novel, false);
    }

    public BookDetailModal(Novel novel, boolean audio) {
        this(novel, audio, false);
    }

    public void show() {
        ModalBox detailModal = ModalBox.none().body((Node)this).title("\u5c0f\u8bf4\u8be6\u60c5").cancel("\u5173\u95ed");
        this.setContainerModal(detailModal);
        detailModal.show();
    }

    public BookDetailModal withActions(Action ... actions) {
        HBox actionsBox = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"actions"});
        block6: for (Action action : actions) {
            switch (action) {
                case ANALYSIS: {
                    this.analysis = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u89e3\u6790\u4e0b\u8f7d"), (String[])new String[]{"btn"});
                    this.analysis.setOnMouseClicked(e -> {
                        this.containerModal.disabledAnimateClose().close();
                        BookHelper.submitAnalysis(this.novel);
                    });
                    actionsBox.getChildren().add((Object)this.analysis);
                    continue block6;
                }
                case BOOKSHELF: {
                    this.bookshelf = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u52a0\u5165\u4e66\u67b6"), (String[])new String[]{"btn"});
                    this.bookshelf.setOnMouseClicked(e -> BookHelper.addBookShelf(this.audio, this.novel, null, () -> this.containerModal.disabledAnimateClose().close()));
                    actionsBox.getChildren().add((Object)this.bookshelf);
                    continue block6;
                }
                case TOC: {
                    this.toc = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u67e5\u770b\u76ee\u5f55"), (String[])new String[]{"btn"});
                    actionsBox.getChildren().add((Object)this.toc);
                    continue block6;
                }
                case DOWNLOAD: {
                    this.download = (IconButton)NodeHelper.addClass((Styleable)new IconButton("\u76f4\u63a5\u4e0b\u8f7d"), (String[])new String[]{"btn"});
                    this.download.setOnMouseClicked(e -> {
                        this.containerModal.disabledAnimateClose().close();
                        BookHelper.submitDownload(this.novel, null, null);
                    });
                    actionsBox.getChildren().add((Object)this.download);
                    continue block6;
                }
            }
        }
        this.getChildren().add((Object)actionsBox);
        return this;
    }

    private HBox createItem(String labelText, String contentText, String ... className) {
        return this.createItem(labelText, contentText, Type.LABEL, className);
    }

    private HBox createItem(String labelText, String contentText, Type type, String ... className) {
        return this.createItem(labelText, contentText, type, (Consumer<String>)null, className);
    }

    private HBox createItem(String labelText, String contentText, Type type, Consumer<String> setter, String ... className) {
        HBox box = (HBox)NodeHelper.addClass((Styleable)new HBox(), (String[])new String[]{"item"});
        if (labelText != null) {
            Label label = (Label)NodeHelper.addClass((Styleable)new Label(labelText.concat(":")), (String[])new String[]{"item-label"});
            box.getChildren().add((Object)label);
        }
        if (StringUtils.isNotBlank((CharSequence)contentText) || type == Type.EDITABLE) {
            Tag content;
            switch (type) {
                case TAG: {
                    content = new Tag(contentText);
                    break;
                }
                case LINK: {
                    Hyperlink hyperlink = new Hyperlink(contentText);
                    if (UrlUtils.isHttpUrl((String)contentText)) {
                        hyperlink.setOnAction(e -> DesktopUtils.openBrowse((String)contentText));
                    }
                    content = hyperlink;
                    break;
                }
                case EDITABLE: {
                    content = this.createEditorBox(contentText, setter);
                    break;
                }
                default: {
                    content = new Label(contentText);
                }
            }
            box.getChildren().add((Object)((Node)NodeHelper.addClass((Styleable)content, (String[])new String[]{"item-content"})));
        }
        if (className.length > 0) {
            NodeHelper.addClass((Styleable)box, (String[])className);
        }
        return box;
    }

    private Node createEditorBox(String text, Consumer<String> setter) {
        if (!this.editable) {
            return new Label(text);
        }
        Label label = new Label(text);
        Icon icon = new Icon((Object)IconFont.EDIT);
        HBox titleBox = (HBox)NodeHelper.addClass((Styleable)new HBox(new Node[]{label, icon}), (String[])new String[]{"editable-box"});
        TextField editor = new TextField(text);
        editor.setPromptText("\u8bf7\u8f93\u5165\u8981\u4fee\u6539\u7684\u5185\u5bb9");
        StackPane panel = new StackPane(new Node[]{titleBox});
        EventUtils.setOnMousePrimaryClick((Node)icon, e -> panel.getChildren().setAll((Object[])new Node[]{editor}));
        editor.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                label.setText(editor.getText());
                if (setter != null) {
                    setter.accept(editor.getText());
                }
                panel.getChildren().setAll((Object[])new Node[]{titleBox});
            }
        });
        return panel;
    }

    public IconButton getBookshelf() {
        return this.bookshelf;
    }

    public IconButton getAnalysis() {
        return this.analysis;
    }

    public IconButton getDownload() {
        return this.download;
    }

    public IconButton getToc() {
        return this.toc;
    }

    public void setContainerModal(ModalBox containerModal) {
        this.containerModal = containerModal;
    }

    public ModalBox getContainerModal() {
        return this.containerModal;
    }

    public static enum Action {
        BOOKSHELF,
        ANALYSIS,
        TOC,
        DOWNLOAD;

    }

    private static enum Type {
        TAG,
        EDITABLE,
        LINK,
        LABEL;

    }
}

