/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.viewmodel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ZipUtil;
import com.google.gson.reflect.TypeToken;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.main.core.webdav.WebDav;
import com.unclezs.novel.app.main.db.beans.AudioBook;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.db.beans.SearchEngine;
import com.unclezs.novel.app.main.db.dao.AudioBookDao;
import com.unclezs.novel.app.main.db.dao.BookDao;
import com.unclezs.novel.app.main.db.dao.SearchEngineDao;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.config.BackupConfig;
import com.unclezs.novel.app.main.views.home.AudioBookShelfView;
import com.unclezs.novel.app.main.views.home.FictionBookshelfView;
import com.unclezs.novel.app.main.views.home.RuleManagerView;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupViewModel {
    private static final Logger log = LoggerFactory.getLogger(BackupViewModel.class);
    public static final String WEB_DAV_BACKUP_FILE_NAME = "backup.zip";
    public static final File BACKUP_LOCAL_FILE = FileUtil.file((String)ResourceManager.WORK_DIR, (String)"backup.zip");
    public static final File BACKUP_BOOK_DIR = FileUtil.file((File)ResourceManager.BACKUP_DIR, (String)"book");
    public static final File BACKUP_AUDIO_DIR = FileUtil.file((File)ResourceManager.BACKUP_DIR, (String)"audio");
    public static final String BACKUP_BOOK_NAME = "book.json";
    public static final String BACKUP_AUDIO_NAME = "audio.json";
    public static final String BACKUP_CONF_NAME = "conf";
    public static final String BACKUP_NAME_SEARCH_ENGINES = "searchEngines.json";
    private final BackupConfig config = SettingManager.manager().getBackup();

    public void backup() {
        File backupDir = ResourceManager.BACKUP_DIR;
        FileUtil.del((File)BACKUP_LOCAL_FILE);
        FileUtil.del((File)backupDir);
        File backupZip = this.createBackup(backupDir);
        this.getWebDav().upload(backupZip);
        FileUtil.del((File)backupDir);
        FileUtil.move((File)backupZip, (File)FileUtil.file((File)backupDir, (String)backupZip.getName()), (boolean)true);
    }

    public void restore() {
        File dir = ResourceManager.BACKUP_DIR;
        FileUtil.del((File)BACKUP_LOCAL_FILE);
        FileUtil.del((File)dir);
        this.getWebDav().download(BACKUP_LOCAL_FILE);
        if (!BACKUP_LOCAL_FILE.exists()) {
            throw new IORuntimeException("\u4e91\u7aef\u5907\u4efd\u4e0d\u5b58\u5728");
        }
        this.restoreBackup(BACKUP_LOCAL_FILE);
        FileUtil.del((File)BACKUP_LOCAL_FILE);
        FileUtil.del((File)dir);
    }

    private WebDav getWebDav() {
        return WebDav.createDefault().setUrl((String)this.config.getUrl().get()).setPassword((String)this.config.getPassword().get()).setUsername((String)this.config.getUsername().get()).child(WEB_DAV_BACKUP_FILE_NAME);
    }

    public boolean enabledWebDav() {
        return !CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{(CharSequence)this.config.getPassword().get(), (CharSequence)this.config.getUrl().get(), (CharSequence)this.config.getUsername().get()});
    }

    public File createBackup(File backupDir) {
        List books;
        File confDir = FileUtil.file((File)backupDir, (String)BACKUP_CONF_NAME);
        FileUtil.mkdir((File)confDir);
        if (Boolean.TRUE.equals(this.config.getBookshelf().get()) && !(books = new BookDao().selectAll()).isEmpty()) {
            for (Book book : books) {
                this.copy(FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String[])new String[]{book.getId(), "cover.jpeg"}), FileUtil.file((File)BACKUP_BOOK_DIR, (String[])new String[]{book.getId(), "cover.jpeg"}));
                this.copy(FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String[])new String[]{book.getId(), "manifest"}), FileUtil.file((File)BACKUP_BOOK_DIR, (String[])new String[]{book.getId(), "manifest"}));
            }
            FileUtil.writeUtf8String((String)GsonUtils.toJson(books), (File)FileUtil.file((File)BACKUP_BOOK_DIR, (String)BACKUP_BOOK_NAME));
        }
        if (Boolean.TRUE.equals(this.config.getAudio().get()) && !(books = new AudioBookDao().selectAll()).isEmpty()) {
            for (Book book : books) {
                this.copy(FileUtil.file((File)AudioBookShelfView.CACHE_FOLDER, (String[])new String[]{book.getId(), "cover.jpeg"}), FileUtil.file((File)BACKUP_AUDIO_DIR, (String[])new String[]{book.getId(), "cover.jpeg"}));
                this.copy(FileUtil.file((File)AudioBookShelfView.CACHE_FOLDER, (String[])new String[]{book.getId(), "manifest"}), FileUtil.file((File)BACKUP_AUDIO_DIR, (String[])new String[]{book.getId(), "manifest"}));
            }
            FileUtil.writeUtf8String((String)GsonUtils.toJson(books), (File)FileUtil.file((File)BACKUP_AUDIO_DIR, (String)BACKUP_AUDIO_NAME));
        }
        if (Boolean.TRUE.equals(this.config.getRule().get())) {
            File ruleFile = ResourceManager.confFile("rules.json");
            this.copy(ruleFile, confDir);
        }
        if (Boolean.TRUE.equals(this.config.getSearchEngine().get())) {
            FileUtil.writeUtf8String((String)GsonUtils.toJson(SearchEngineDao.me().all()), (File)FileUtil.file((File)backupDir, (String)BACKUP_NAME_SEARCH_ENGINES));
        }
        return ZipUtil.zip((String)backupDir.getAbsolutePath(), (String)BACKUP_LOCAL_FILE.getAbsolutePath());
    }

    public void restoreBackup(File backupZip) {
        File searchEngineJsonFile;
        File backupDir = ZipUtil.unzip((File)backupZip);
        File confDir = FileUtil.file((File)backupDir, (String)BACKUP_CONF_NAME);
        File ruleFile = FileUtil.file((File)confDir, (String)"rules.json");
        if (ruleFile.exists()) {
            this.copy(ruleFile, ResourceManager.CONF_DIR);
            ((RuleManagerView)((Object)AppContext.getView(RuleManagerView.class))).importRule(ruleFile);
        }
        if (BACKUP_BOOK_DIR.exists()) {
            File bookFile = FileUtil.file((File)BACKUP_BOOK_DIR, (String)BACKUP_BOOK_NAME);
            List books = (List)GsonUtils.me().fromJson(FileUtil.readUtf8String((File)bookFile), new TypeToken<List<Book>>(){}.getType());
            FileUtil.del((File)bookFile);
            FictionBookshelfView bookshelf = (FictionBookshelfView)((Object)AppContext.getView(FictionBookshelfView.class));
            books.forEach(bookshelf::addOrUpdateBook);
            if (!books.isEmpty()) {
                this.copy(BACKUP_BOOK_DIR, FictionBookshelfView.CACHE_FOLDER.getParentFile());
            }
        }
        if (BACKUP_AUDIO_DIR.exists()) {
            File file = FileUtil.file((File)BACKUP_AUDIO_DIR, (String)BACKUP_AUDIO_NAME);
            String string = FileUtil.readUtf8String((File)file);
            List books = (List)GsonUtils.me().fromJson(string, new TypeToken<List<AudioBook>>(){}.getType());
            FileUtil.del((File)file);
            AudioBookShelfView bookshelf = (AudioBookShelfView)((Object)AppContext.getView(AudioBookShelfView.class));
            books.forEach(bookshelf::addOrUpdateBook);
            if (!books.isEmpty()) {
                this.copy(BACKUP_AUDIO_DIR, AudioBookShelfView.CACHE_FOLDER.getParentFile());
            }
        }
        if ((searchEngineJsonFile = FileUtil.file((File)backupDir, (String)BACKUP_NAME_SEARCH_ENGINES)).exists()) {
            List searchEngines = (List)GsonUtils.me().fromJson(FileUtil.readUtf8String((File)searchEngineJsonFile), new TypeToken<List<SearchEngine>>(){}.getType());
            searchEngines.forEach(searchEngine -> SearchEngineDao.me().createOrUpdate(searchEngine));
            SearchEngineDao.me().all().setAll(SearchEngineDao.me().selectAll());
        }
    }

    private void copy(File src, File target) {
        if (!src.exists()) {
            log.warn("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\uff1a{}", (Object)src);
            return;
        }
        FileUtil.copy((File)src, (File)target, (boolean)true);
    }

    public BackupConfig getConfig() {
        return this.config;
    }
}

