/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.util.StringBuilderWriter;

public final class VelocityUtils {
    private static VelocityEngine velocityEngine = null;

    private static VelocityEngine getVelocityEngine() {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("resource.loaders", (Object)"class");
            velocityEngine.setProperty("resource.loader.class.class", (Object)ClasspathResourceLoader.class.getName());
            velocityEngine.init();
        }
        return velocityEngine;
    }

    public static String render(String templatePath, Object data) {
        VelocityContext context = new VelocityContext();
        context.put("data", data);
        context.put("uuid", UUID.class);
        Template template = VelocityUtils.getVelocityEngine().getTemplate(templatePath, StandardCharsets.UTF_8.name());
        StringBuilderWriter writer = new StringBuilderWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public static void render(String templatePath, Object info, File output) {
        String data = VelocityUtils.render(templatePath, info);
        FileUtil.writeUtf8String((String)data, (File)output);
    }

    private VelocityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

