/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import com.jfoenix.utils.JFXUtilities;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.main.manager.SettingManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.stage.Stage;

public final class UpdateUtils {
    public static final String CHANGE_LOG_KEY = "changeLog";
    public static final String VERSION_KEY = "version";
    public static final String HAS_NEW = "hasNew";

    public static void checkForUpdate(Stage stage) {
        Executor.run(() -> {
            Object userData = stage.getUserData();
            if (userData == null) {
                return;
            }
            Map data = (Map)userData;
            Boolean hasNew = data.getOrDefault(HAS_NEW, false);
            List changeLog = (List)data.get(CHANGE_LOG_KEY);
            StringBuilder whatNew = new StringBuilder();
            for (String newItem : changeLog) {
                whatNew.append(newItem).append("\n");
            }
            String version = (String)data.get(VERSION_KEY);
            SettingManager.manager().setVersion(version);
            if (!Boolean.TRUE.equals(hasNew)) {
                return;
            }
            Label changelog = new Label(whatNew.toString());
            changelog.setWrapText(true);
            ScrollPane content = new ScrollPane();
            content.setContent((Node)changelog);
            content.setFitToWidth(true);
            content.setMaxHeight(200.0);
            Executor.run(() -> JFXUtilities.runInFX(() -> {
                String info = "\u5f53\u524d\u7248\u672c - V".concat(version);
                ModalBox.none().cancel("\u4e86\u89e3\u4e86").body((Node)content).title(info).show();
            }), (long)1000L);
        });
    }

    public static void mockUpdate(Stage stage) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put(CHANGE_LOG_KEY, List.of("\u6211\u662f\u8c01\u5462", "\u4f60\u53c8\u662f\u8c01\u5462"));
        map.put(VERSION_KEY, "5.5.54");
        map.put(HAS_NEW, true);
        stage.setUserData(map);
    }

    private UpdateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

