/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.executor.Executor;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSSession;

public final class MixPanelHelper {
    private static final Logger log = LoggerFactory.getLogger(MixPanelHelper.class);
    public static final String NT_AUTHORITY = "NT AUTHORITY";
    public static final String TOKEN = System.getProperty("mixPanel.token");
    private static String computerName;
    private static String clientId;
    private static boolean profile;

    public static void event(String name, Map<String, Object> eventPropsMap) {
        Executor.run(() -> MixPanelHelper.sendEvent(name, eventPropsMap));
    }

    public static void event(String name) {
        MixPanelHelper.event(name, null);
    }

    public static void sendEvent(String name, Map<String, Object> eventPropsMap) {
        try {
            if (StringUtils.isBlank((CharSequence)TOKEN)) {
                return;
            }
            MixpanelAPI mixpanel = new MixpanelAPI();
            MessageBuilder messageBuilder = new MessageBuilder(TOKEN);
            JSONObject eventProps = null;
            if (eventPropsMap != null) {
                eventProps = new JSONObject();
                for (Map.Entry<String, Object> entry : eventPropsMap.entrySet()) {
                    eventProps.put(entry.getKey(), entry.getValue());
                }
            }
            JSONObject event = messageBuilder.event(clientId, name, eventProps);
            if (profile) {
                JSONObject props = new JSONObject();
                props.put("$name", (Object)computerName);
                props.put("$platform", (Object)System.getProperty("os.name", "\u672a\u77e5"));
                JSONObject userProfile = messageBuilder.set(clientId, props);
                ClientDelivery delivery = new ClientDelivery();
                delivery.addMessage(userProfile);
                delivery.addMessage(event);
                mixpanel.deliver(delivery, true);
                profile = false;
            } else {
                mixpanel.sendMessage(event);
            }
        }
        catch (Exception e) {
            log.debug("mixPanel\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void getSystemInfo() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        ComputerSystem computerSystem = hardware.getComputerSystem();
        clientId = computerSystem.getSerialNumber();
        for (OSSession session : systemInfo.getOperatingSystem().getSessions()) {
            if (session.getLoginTime() == 0L || NT_AUTHORITY.equals(session.getHost())) continue;
            computerName = session.getUserName();
            return;
        }
        computerName = clientId;
    }

    private MixPanelHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        profile = true;
        MixPanelHelper.getSystemInfo();
    }
}

