/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import com.unclezs.novel.app.main.util.BytesEncodingDetect;
import java.io.File;
import lombok.NonNull;

public final class EncodingDetect {
    public static String getEncode(byte[] bytes) {
        int len = Math.min(bytes.length, 2000);
        byte[] cBytes = new byte[len];
        System.arraycopy(bytes, 0, cBytes, 0, len);
        BytesEncodingDetect bytesEncodingDetect = new BytesEncodingDetect();
        String code = BytesEncodingDetect.javaname[bytesEncodingDetect.detectEncoding(cBytes)];
        if ("Unicode".equals(code) && cBytes[0] == -1) {
            code = "UTF-16LE";
        }
        return code;
    }

    public static String getEncode(@NonNull String filePath) {
        byte[] tempByte;
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        BytesEncodingDetect s = new BytesEncodingDetect();
        String fileCode = BytesEncodingDetect.javaname[s.detectEncoding(new File(filePath))];
        if ("Unicode".equals(fileCode) && (tempByte = BytesEncodingDetect.getFileBytes(new File(filePath)))[0] == -1) {
            fileCode = "UTF-16LE";
        }
        return fileCode;
    }

    public static String getEncode(@NonNull File file) {
        byte[] tempByte;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        BytesEncodingDetect s = new BytesEncodingDetect();
        String fileCode = BytesEncodingDetect.javaname[s.detectEncoding(file)];
        if ("Unicode".equals(fileCode) && (tempByte = BytesEncodingDetect.getFileBytes(file))[0] == -1) {
            fileCode = "UTF-16LE";
        }
        return fileCode;
    }

    private EncodingDetect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

