/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.ZipUtil;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.SystemUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.util.VelocityUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EbookUtils {
    private static final Logger log = LoggerFactory.getLogger(EbookUtils.class);
    public static final String EBOOK_TMP_SUFFIX = "_Ebook";
    private static final String KINDLEGEN = "kindlegen";
    private static final String KINDLEGEN_EXE = "kindlegen.exe";
    private static final String KINDLEGEN_LINUX = "kindlegen_linux";
    private static final String EPUB_SUFFIX = ".epub";
    private static final String MOBI_SUFFIX = ".mobi";
    private static final String MIMETYPE = "mimetype";
    private static final String EPUB_TEMPLATES = "templates/epub/";
    private static final String OUT_PATH_STYLE_CSS = "style/style.css";
    private static final String OUT_PATH_CONTAINER_XML = "META-INF/container.xml";
    private static final String OUT_PATH_COVER = "cover.jpeg";
    private static final String OUT_PATH_CONTENT_OPF = "content.opf";
    private static final String OUT_PATH_TOC_NCX = "toc.ncx";
    private static final String OUT_PATH_TOC_HTML = "text/toc.html";
    private static final String TEMPLATE_CHAPTER = "templates/epub/".concat("text/chapter.html.vm");
    private static final String TEMPLATE_TOC_HTML = "templates/epub/".concat("text/toc.html.vm");
    private static final String TEMPLATE_CONTENT_OPF = "templates/epub/".concat("content.opf.vm");
    private static final String TEMPLATE_TOC_NCX = "templates/epub/".concat("toc.ncx.vm");
    private static final String TEMPLATE_MIMETYPE = "templates/epub/".concat("mimetype");
    private static final String TEMPLATE_STYLESHEET = "templates/epub/".concat("style/style.css");
    private static final String TEMPLATE_CONTAINER_XML = "templates/epub/".concat("META-INF/container.xml");

    public static void toEpub(File outDir) {
        File tmpDir = FileUtil.file((String)outDir.getAbsolutePath().concat(EBOOK_TMP_SUFFIX));
        ZipUtil.zip((String)tmpDir.getAbsolutePath(), (String)outDir.getAbsolutePath().concat(EPUB_SUFFIX));
    }

    public static void toMobi(File outDir) {
        File tmpDir = FileUtil.file((String)outDir.getAbsolutePath().concat(EBOOK_TMP_SUFFIX));
        String gen = null;
        gen = SystemUtils.isWindows() ? ResourceManager.binFile(KINDLEGEN_EXE).getAbsolutePath() : (SystemUtils.isLinux() ? ResourceManager.binFile(KINDLEGEN_LINUX).getAbsolutePath() : ResourceManager.binFile(KINDLEGEN).getAbsolutePath());
        FileUtil.file((String)gen).setExecutable(true, false);
        String opf = FileUtil.file((File)tmpDir, (String)OUT_PATH_CONTENT_OPF).getAbsolutePath();
        String filename = outDir.getName().concat(MOBI_SUFFIX);
        try {
            String command = String.format("%s -dont_append_source %s -c1 -o %s", gen, opf, filename);
            Process process = Runtime.getRuntime().exec(command);
            String result = RuntimeUtil.getResult((Process)process);
            process.waitFor();
            File mobiFile = FileUtil.file((File)tmpDir, (String)filename);
            if (mobiFile.exists()) {
                FileUtil.move((File)FileUtil.file((File)tmpDir, (String)filename), (File)FileUtil.file((String)outDir.getParent(), (String)filename), (boolean)true);
            } else {
                log.warn("mobi\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            log.trace("\u751f\u6210mobi\u65f6kindlegen\u8f93\u51fa\uff1a{}", (Object)result);
        }
        catch (InterruptedException e) {
            log.error("\u751f\u6210mobi\u65f6\u6587\u4ef6\u88ab\u4e2d\u65ad\uff1a{}", (Object)outDir, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("\u751f\u6210mobi\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)outDir, (Object)e);
        }
    }

    public static File toEbook(Novel novel, File outDir, boolean generateChapter) {
        File tmpDir = FileUtil.file((String)outDir.getAbsolutePath().concat(EBOOK_TMP_SUFFIX));
        FileUtil.writeFromStream((InputStream)ResourceUtils.stream((String)TEMPLATE_CONTAINER_XML), (File)FileUtil.file((File)tmpDir, (String)OUT_PATH_CONTAINER_XML));
        FileUtil.writeFromStream((InputStream)ResourceUtils.stream((String)TEMPLATE_MIMETYPE), (File)FileUtil.file((File)tmpDir, (String)MIMETYPE));
        FileUtil.writeFromStream((InputStream)ResourceUtils.stream((String)TEMPLATE_STYLESHEET), (File)FileUtil.file((File)tmpDir, (String)OUT_PATH_STYLE_CSS));
        EbookUtils.generateCover(novel.getCoverUrl(), FileUtil.file((File)tmpDir, (String)OUT_PATH_COVER));
        VelocityUtils.render(TEMPLATE_CONTENT_OPF, novel, FileUtil.file((File)tmpDir, (String)OUT_PATH_CONTENT_OPF));
        VelocityUtils.render(TEMPLATE_TOC_NCX, novel, FileUtil.file((File)tmpDir, (String)OUT_PATH_TOC_NCX));
        VelocityUtils.render(TEMPLATE_TOC_HTML, novel, FileUtil.file((File)tmpDir, (String)OUT_PATH_TOC_HTML));
        if (generateChapter && CollectionUtils.isNotEmpty((Collection)novel.getChapters())) {
            novel.getChapters().forEach(chapter -> EbookUtils.generateChapter(chapter, outDir));
        }
        return tmpDir;
    }

    public static void generateChapter(Chapter chapter, File outDir) {
        File tmpDir = FileUtil.file((String)outDir.getAbsolutePath().concat(EBOOK_TMP_SUFFIX));
        VelocityUtils.render(TEMPLATE_CHAPTER, chapter, FileUtil.file((File)tmpDir, (String)String.format("text/%d.html", chapter.getOrder())));
    }

    private static void generateCover(String coverUrl, File out) {
        if (StringUtils.isNotBlank((CharSequence)coverUrl)) {
            try {
                byte[] cover = UrlUtils.isHttpUrl((String)coverUrl) ? Http.bytes((RequestParams)RequestParams.create((String)coverUrl)) : FileUtil.readBytes((File)FileUtil.file((String)coverUrl));
                FileUtil.writeBytes((byte[])cover, (File)out);
            }
            catch (Exception e) {
                log.error("epub\u5c01\u9762\u751f\u6210\u5931\u8d25\uff1a\u5c01\u9762\u5730\u5740\uff1a{}", (Object)coverUrl, (Object)e);
            }
        }
    }

    private EbookUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

