/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public final class DebugUtils {
    public static final String DEBUG_LOGGER_NAME = "com.unclezs";
    public static final Logger DEBUG_LOGGER;
    public static final LoggerContext CONTEXT;

    public static void debug() {
        DEBUG_LOGGER.setLevel(Level.TRACE);
    }

    public static void info() {
        DEBUG_LOGGER.setLevel(Level.INFO);
    }

    public static void debug(boolean debug) {
        if (debug) {
            DebugUtils.debug();
        } else {
            DebugUtils.info();
        }
    }

    public static void stop() {
        CONTEXT.stop();
    }

    public static void start() {
        CONTEXT.start();
    }

    public static void level(Level level) {
        DEBUG_LOGGER.setLevel(level);
    }

    public static LoggerContext reconfigure(String configInClasspath) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            if (configInClasspath != null && !configInClasspath.isEmpty()) {
                configurator.doConfigure(Objects.requireNonNull(DebugUtils.class.getResource(configInClasspath)));
            }
        }
        catch (JoranException ignored) {
            StatusPrinter.print((Context)context);
        }
        return context;
    }

    public static void logMsg(String loggerName) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)loggerName);
        logger.trace("test message by different level");
        logger.debug("test message by different level");
        logger.info("test message by different level");
        logger.warn("test message by different level");
        logger.error("test message by different level");
    }

    private DebugUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        CONTEXT = (LoggerContext)LoggerFactory.getILoggerFactory();
        DEBUG_LOGGER = CONTEXT.getLogger(DEBUG_LOGGER_NAME);
    }
}

