/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.unclezs.novel.app.main.db.beans.DownloadHistory;
import com.unclezs.novel.app.main.exception.DbException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbHelper {
    private static final Logger log = LoggerFactory.getLogger(DbHelper.class);
    private static final String DATABASE_URL = "jdbc:sqlite:conf/core.db";
    private static ConnectionSource connectionSource;

    public static <T, I> Dao<T, I> getDao(Class<T> clazz) {
        try {
            return DaoManager.createDao((ConnectionSource)DbHelper.getConnectionSource(), clazz);
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6DAO\u5931\u8d25\uff1a{}", clazz, (Object)e);
            throw new DbException("\u83b7\u53d6DAO\u5931\u8d25");
        }
    }

    public static void clearTable(Class<?> dataClazz) throws SQLException {
        TableUtils.clearTable((ConnectionSource)DbHelper.getConnectionSource(), dataClazz);
    }

    public static ConnectionSource getConnectionSource() throws SQLException {
        if (connectionSource == null) {
            connectionSource = new JdbcConnectionSource(DATABASE_URL);
        }
        return connectionSource;
    }

    public static void main(String[] args) throws SQLException {
        TableUtils.dropTable(DbHelper.getDao(DownloadHistory.class), (boolean)false);
        TableUtils.createTable((ConnectionSource)DbHelper.getConnectionSource(), DownloadHistory.class);
    }

    private DbHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

