/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.SerializationUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.main.manager.RuleManager;
import com.unclezs.novel.app.main.model.BookBundle;
import com.unclezs.novel.app.main.model.BookCache;
import com.unclezs.novel.app.main.views.home.AnalysisView;
import com.unclezs.novel.app.main.views.home.AudioBookShelfView;
import com.unclezs.novel.app.main.views.home.DownloadManagerView;
import com.unclezs.novel.app.main.views.home.FictionBookshelfView;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BookHelper {
    private static final Logger log = LoggerFactory.getLogger(BookHelper.class);
    public static final String COVER_NAME = "cover.jpeg";
    public static final String MANIFEST = "manifest";

    public static void downloadCover(String cover, String referer, File outDir, Consumer<String> callback) {
        if (cover == null) {
            return;
        }
        Executor.run(() -> callback.accept(BookHelper.downloadCover(cover, referer, outDir)));
    }

    public static String downloadCover(String cover, String referer, File outDir) {
        if (cover == null) {
            return null;
        }
        try {
            File coverFile = FileUtil.file((File)outDir, (String)COVER_NAME);
            RequestParams params = RequestParams.create((String)cover);
            if (StringUtils.isNotBlank((CharSequence)referer)) {
                params.addHeader("Referer", referer);
            }
            FileUtil.writeBytes((byte[])Http.bytes((RequestParams)params), (File)coverFile);
            return coverFile.getAbsolutePath();
        }
        catch (IOException e) {
            log.error("\u5c01\u9762\u4e0b\u8f7d\u5931\u8d25\uff1a{}", (Object)cover, (Object)e);
            throw new IORuntimeException("\u5c01\u9762\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
    }

    public static void cache(BookCache bookCache, File outDir) {
        File ruleCache = FileUtil.file((File)outDir, (String)MANIFEST);
        FileUtil.writeUtf8String((String)GsonUtils.toJson((Object)bookCache), (File)ruleCache);
    }

    public static BookCache loadCache(File outDir) {
        File chapterCache = FileUtil.file((File)outDir, (String)MANIFEST);
        if (chapterCache.exists()) {
            return (BookCache)GsonUtils.parse((String)FileUtil.readUtf8String((File)chapterCache), BookCache.class);
        }
        return new BookCache();
    }

    public static void submitAnalysis(Novel novel) {
        SidebarNavigateBundle bundle = (SidebarNavigateBundle)new SidebarNavigateBundle().put("novel-info", (Object)novel);
        ((AnalysisView)((Object)AppContext.getView(AnalysisView.class))).getNavigation().navigate(AnalysisView.class, bundle);
    }

    public static void submitDownload(Novel novel, AnalyzerRule rule, List<Chapter> toc) {
        if (rule == null) {
            rule = RuleManager.getOrDefault(novel.getUrl());
        }
        BookBundle bookBundle = new BookBundle(novel, rule);
        if (CollUtil.isNotEmpty(toc)) {
            bookBundle.getNovel().setChapters((List)SerializationUtils.deepClone(toc));
        }
        SidebarNavigateBundle bundle = (SidebarNavigateBundle)new SidebarNavigateBundle().put("bundle_download_key", (Object)bookBundle);
        ((DownloadManagerView)((Object)AppContext.getView(DownloadManagerView.class))).getNavigation().navigate(DownloadManagerView.class, bundle);
    }

    public static void addBookShelf(boolean audio, Novel novel, AnalyzerRule analyzerRule, Runnable onSuccess) {
        if (analyzerRule == null) {
            analyzerRule = RuleManager.getOrDefault(novel.getUrl());
        }
        AnalyzerRule rule = analyzerRule;
        BookBundle bookBundle = new BookBundle(novel, rule);
        if (CollUtil.isEmpty((Collection)novel.getChapters())) {
            TaskFactory.create(() -> {
                NovelSpider spider = new NovelSpider(rule);
                return spider.toc(novel.getUrl());
            }).onSuccess(toc -> {
                bookBundle.getNovel().setChapters(toc);
                BookHelper.addBookShelf(audio, bookBundle, onSuccess);
            }).onFailed(error -> {
                Toast.error((String)"\u52a0\u5165\u4e66\u67b6\u5931\u8d25");
                log.error("\u52a0\u5165\u4e66\u67b6\u5931\u8d25\uff1a{}", (Object)novel, error);
            }).start();
        } else {
            bookBundle.getNovel().setChapters((List)SerializationUtils.deepClone((Object)novel.getChapters()));
            BookHelper.addBookShelf(audio, bookBundle, onSuccess);
        }
    }

    private static void addBookShelf(boolean audio, BookBundle bookBundle, Runnable onSuccess) {
        if (onSuccess != null) {
            onSuccess.run();
        }
        SidebarNavigateBundle bundle = (SidebarNavigateBundle)new SidebarNavigateBundle().put(audio ? "bundle-audio-book" : "bundle-book-key", (Object)bookBundle);
        ((FictionBookshelfView)((Object)AppContext.getView(FictionBookshelfView.class))).getNavigation().navigate(audio ? AudioBookShelfView.class : FictionBookshelfView.class, bundle);
    }

    private BookHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

