/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.manager;

import cn.hutool.core.util.ArrayUtil;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import com.unclezs.novel.app.main.App;
import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrayManager {
    private static final Logger log = LoggerFactory.getLogger(TrayManager.class);
    private static TrayIcon trayIcon;

    public static void init() {
        try {
            BufferedImage image = ImageIO.read(ResourceUtils.stream((String)"assets/logo/icon-48.png"));
            PopupMenu popupMenu = new PopupMenu();
            MenuItem show = new MenuItem("show");
            show.addActionListener(e -> Executor.runFx(App::requestShow));
            MenuItem exit = new MenuItem("exit");
            exit.addActionListener(e -> Executor.runFx(App::stopApp));
            popupMenu.add(show);
            popupMenu.add(exit);
            trayIcon = new TrayIcon(image, "Uncle\u5c0f\u8bf4", null);
            trayIcon.setPopupMenu(popupMenu);
            trayIcon.setImageAutoSize(true);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getButton() == 1) {
                        Executor.runFx(App::requestShow);
                    }
                }
            });
            TrayManager.tray();
        }
        catch (Exception e2) {
            log.error("\u6258\u76d8\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e2);
        }
    }

    public static void tray() {
        try {
            if (trayIcon != null && !ArrayUtil.contains((Object[])SystemTray.getSystemTray().getTrayIcons(), (Object)trayIcon)) {
                SystemTray.getSystemTray().add(trayIcon);
            }
        }
        catch (AWTException e) {
            log.error("\u6258\u76d8\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    public static void hide() {
        if (trayIcon != null) {
            Executor.run(() -> SystemTray.getSystemTray().remove(trayIcon));
        }
    }

    private TrayManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

