/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.manager;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.app.framework.serialize.PropertyJsonSerializer;
import com.unclezs.novel.app.main.manager.LanguageManager;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.model.config.BackupConfig;
import com.unclezs.novel.app.main.model.config.BasicConfig;
import com.unclezs.novel.app.main.model.config.BookShelfConfig;
import com.unclezs.novel.app.main.model.config.DownloadConfig;
import com.unclezs.novel.app.main.model.config.HotKeyConfig;
import com.unclezs.novel.app.main.model.config.ProxyConfig;
import com.unclezs.novel.app.main.model.config.ReaderConfig;
import com.unclezs.novel.app.main.util.DebugUtils;
import java.io.File;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class SettingManager {
    public static final String CONFIG_FILE_NAME = "conf.json";
    private static SettingManager manager;
    private String version = "5.0";
    private BasicConfig basic = new BasicConfig();
    private DownloadConfig download = new DownloadConfig();
    private ReaderConfig reader = new ReaderConfig();
    private BookShelfConfig bookShelf = new BookShelfConfig();
    private BackupConfig backup = new BackupConfig();
    private ProxyConfig proxy = new ProxyConfig();
    private HotKeyConfig hotkey = new HotKeyConfig();
    private ObjectProperty<Boolean> debug = new SimpleObjectProperty((Object)false);

    public static SettingManager manager() {
        return manager;
    }

    public static void init() {
        File confFile = ResourceManager.confFile(CONFIG_FILE_NAME);
        if (confFile.exists()) {
            String confJson = FileUtil.readUtf8String((File)confFile);
            manager = (SettingManager)PropertyJsonSerializer.fromJson((String)confJson, SettingManager.class);
        } else {
            manager = new SettingManager();
        }
        Locale.setDefault(LanguageManager.locale((String)SettingManager.manager.basic.getLang().getValue()));
        ProxyConfig.initHttpProxy();
        DebugUtils.debug((Boolean)SettingManager.manager().getDebug().get());
    }

    public static void save() {
        File confFile = ResourceManager.confFile(CONFIG_FILE_NAME);
        FileUtil.writeUtf8String((String)PropertyJsonSerializer.toJson((Object)manager), (File)confFile);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBasic(BasicConfig basic) {
        this.basic = basic;
    }

    public void setDownload(DownloadConfig download) {
        this.download = download;
    }

    public void setReader(ReaderConfig reader) {
        this.reader = reader;
    }

    public void setBookShelf(BookShelfConfig bookShelf) {
        this.bookShelf = bookShelf;
    }

    public void setBackup(BackupConfig backup) {
        this.backup = backup;
    }

    public void setProxy(ProxyConfig proxy) {
        this.proxy = proxy;
    }

    public void setHotkey(HotKeyConfig hotkey) {
        this.hotkey = hotkey;
    }

    public void setDebug(ObjectProperty<Boolean> debug) {
        this.debug = debug;
    }

    public String getVersion() {
        return this.version;
    }

    public BasicConfig getBasic() {
        return this.basic;
    }

    public DownloadConfig getDownload() {
        return this.download;
    }

    public ReaderConfig getReader() {
        return this.reader;
    }

    public BookShelfConfig getBookShelf() {
        return this.bookShelf;
    }

    public BackupConfig getBackup() {
        return this.backup;
    }

    public ProxyConfig getProxy() {
        return this.proxy;
    }

    public HotKeyConfig getHotkey() {
        return this.hotkey;
    }

    public ObjectProperty<Boolean> getDebug() {
        return this.debug;
    }
}

