/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.manager;

import cn.hutool.core.bean.BeanUtil;
import com.unclezs.novel.analyzer.core.helper.RuleHelper;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.app.main.manager.ResourceManager;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class RuleManager {
    public static final String RULES_FILE_NAME = "rules.json";
    private static final ObservableList<AnalyzerRule> RULES;

    public static ObservableList<AnalyzerRule> rules() {
        return RULES;
    }

    public static void addRule(AnalyzerRule rule) {
        AnalyzerRule old = RuleHelper.getRule((String)rule.getSite());
        if (old != null) {
            BeanUtil.copyProperties((Object)rule, (Object)old, (String[])new String[0]);
            return;
        }
        RuleHelper.addRule((AnalyzerRule)rule);
    }

    public static boolean exist(AnalyzerRule rule) {
        return RuleHelper.getRule((String)rule.getSite()) != null;
    }

    public static AnalyzerRule get(String url) {
        return RuleHelper.getRule((String)url);
    }

    public static AnalyzerRule getOrDefault(String url) {
        return RuleHelper.getOrDefault((String)url);
    }

    public static void update(List<AnalyzerRule> rules) {
        RuleHelper.setRules(rules);
    }

    public static void save() {
        ResourceManager.saveConfFile(RULES_FILE_NAME, GsonUtils.toJson(RULES));
    }

    public static List<AnalyzerRule> textRules() {
        return RULES.stream().filter(rule -> Boolean.TRUE.equals(rule.getEnabled()) && rule.isEffective() && Boolean.FALSE.equals(rule.getAudio())).collect(Collectors.toList());
    }

    public static List<AnalyzerRule> textSearchRules() {
        return RuleManager.textRules().stream().filter(rule -> rule.getSearch() != null && rule.getSearch().isEffective()).sorted(Comparator.comparingInt(AnalyzerRule::getWeight)).collect(Collectors.toList());
    }

    public static List<AnalyzerRule> audioRules() {
        return RULES.stream().filter(rule -> Boolean.TRUE.equals(rule.getEnabled()) && rule.isEffective() && Boolean.TRUE.equals(rule.getAudio())).collect(Collectors.toList());
    }

    public static List<AnalyzerRule> audioSearchRules() {
        return RuleManager.audioRules().stream().filter(rule -> rule.getSearch() != null && rule.getSearch().isEffective()).sorted(Comparator.comparingInt(AnalyzerRule::getWeight)).collect(Collectors.toList());
    }

    private RuleManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        if (ResourceManager.confFile(RULES_FILE_NAME).exists()) {
            RuleHelper.loadRules((String)ResourceManager.readConfFile(RULES_FILE_NAME));
        }
        RULES = FXCollections.observableList((List)RuleHelper.rules());
        RuleHelper.setOnRuleChangeListener(arg_0 -> RULES.setAll(arg_0));
    }
}

