/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.manager;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import java.io.File;
import java.nio.file.Path;

public final class ResourceManager {
    public static final String WORK_DIR = FileUtil.normalize((String)new File(".").getAbsolutePath());
    public static final File CONF_DIR = FileUtil.file((String)WORK_DIR, (String)"conf");
    public static final File PLUGINS_DIR = FileUtil.file((String)WORK_DIR, (String)"plugins");
    public static final File CACHE_DIR = FileUtil.file((String)WORK_DIR, (String)"caches");
    public static final File BIN_DIR = FileUtil.file((String)WORK_DIR, (String)"bin");
    public static final File DOWNLOAD_DIR = FileUtil.file((String)WORK_DIR, (String)"downloads");
    public static final File BACKUP_DIR = FileUtil.file((String)WORK_DIR, (String)"backup");
    public static final File FONTS_DIR = FileUtil.file((String)WORK_DIR, (String)"fonts");

    public static File confFile(String path) {
        return FileUtil.file((File)CONF_DIR, (String)path);
    }

    public static File cacheFile(String path) {
        return FileUtil.file((File)CACHE_DIR, (String)path);
    }

    public static String readConfFile(String path) {
        return FileUtil.readUtf8String((File)FileUtil.file((File)CONF_DIR, (String)path));
    }

    public static void saveConfFile(String path, String content) {
        FileUtil.writeUtf8String((String)content, (File)FileUtil.file((File)CONF_DIR, (String)path));
    }

    public static File binFile(String path) {
        return FileUtil.file((File)BIN_DIR, (String)path);
    }

    public static File pluginsFile(String path) {
        return FileUtil.file((File)PLUGINS_DIR, (String)path);
    }

    public static String findResource(String location) {
        if (StringUtils.isBlank((CharSequence)location)) {
            return null;
        }
        if (Path.of(location, new String[0]).isAbsolute()) {
            return location;
        }
        if (ResourceUtils.exist((String)location)) {
            return ResourceUtils.externalForm((String)location);
        }
        File resource = FileUtil.file((String)WORK_DIR, (String)location);
        if (resource.exists()) {
            return resource.getAbsolutePath();
        }
        return null;
    }

    private ResourceManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

