/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.manager;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class LanguageManager {
    private static final Map<String, String> LANG = new HashMap<String, String>(16);

    public static ObservableList<String> names() {
        return FXCollections.observableArrayList(LANG.keySet());
    }

    public static String name(Locale locale) {
        String localeString = String.format("%s_%s", locale.getLanguage(), locale.getCountry());
        for (Map.Entry<String, String> entry : LANG.entrySet()) {
            if (!entry.getValue().equals(localeString)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Locale locale(String name) {
        String locale = LANG.get(name);
        if (locale == null) {
            return Locale.getDefault();
        }
        String[] localeSplit = locale.split("_");
        if (localeSplit.length > 1) {
            return new Locale(localeSplit[0], localeSplit[1]);
        }
        return new Locale(localeSplit[0]);
    }

    private LanguageManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        LANG.put("\u7b80\u4f53\u4e2d\u6587", "zh_CN");
        LANG.put("\u7e41\u4f53\u4e2d\u6587", "zh_TW");
        LANG.put("English", "en");
    }
}

