/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.manager;

import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyCombination;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyManager;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.manager.TrayManager;
import com.unclezs.novel.app.main.model.config.HotKeyConfig;

public final class HotkeyManager {
    private static void registerBossKey(String keystroke) {
        HotKeyManager.registerGlobal((HotKeyCombination)HotKeyCombination.fromStroke((String)keystroke), key -> HotkeyManager.triggerBossKey());
    }

    public static void triggerBossKey() {
        Executor.runFx(() -> {
            if (App.stage().isIconified()) {
                App.stage().setIconified(false);
                return;
            }
            if (App.stage().isShowing()) {
                App.tray();
                TrayManager.hide();
            } else {
                App.requestShow();
                TrayManager.tray();
            }
        });
    }

    public static void init() {
        HotKeyConfig config = SettingManager.manager().getHotkey();
        HotkeyManager.registerBossKey(config.getGlobalBossKey());
        if (StringUtils.isNotBlank((CharSequence)config.getReaderNextChapter())) {
            HotKeyManager.registerWindowHotkey((HotKeyCombination)HotKeyCombination.fromStroke((String)config.getReaderNextChapter()));
        }
        if (StringUtils.isNotBlank((CharSequence)config.getReaderToc())) {
            HotKeyManager.registerWindowHotkey((HotKeyCombination)HotKeyCombination.fromStroke((String)config.getReaderToc()));
        }
        if (StringUtils.isNotBlank((CharSequence)config.getReaderNextPage())) {
            HotKeyManager.registerWindowHotkey((HotKeyCombination)HotKeyCombination.fromStroke((String)config.getReaderNextPage()));
        }
        if (StringUtils.isNotBlank((CharSequence)config.getReaderPreChapter())) {
            HotKeyManager.registerWindowHotkey((HotKeyCombination)HotKeyCombination.fromStroke((String)config.getReaderPreChapter()));
        }
        if (StringUtils.isNotBlank((CharSequence)config.getReaderPrePage())) {
            HotKeyManager.registerWindowHotkey((HotKeyCombination)HotKeyCombination.fromStroke((String)config.getReaderPrePage()));
        }
    }

    public static void destroy() {
        HotKeyManager.clearGlobal();
    }

    private HotkeyManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

