/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.enums;

import cn.hutool.core.text.CharSequenceUtil;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.app.framework.support.LocalizedSupport;

public enum SearchType implements LocalizedSupport
{
    ALL("novel.all"),
    NAME("novel.name"),
    AUTHOR("novel.author"),
    SPEAKER("novel.speaker");

    private final String desc;

    private SearchType(String desc) {
        this.desc = this.localized(desc);
    }

    public static SearchType fromValue(String desc) {
        for (SearchType searchType : SearchType.values()) {
            if (!searchType.desc.equals(desc)) continue;
            return searchType;
        }
        throw new IllegalArgumentException("\u641c\u7d22\u7c7b\u578b\u503c\u672a\u627e\u5230:" + desc);
    }

    public static boolean match(String searchType, String keyword, Novel novel) {
        return SearchType.match(SearchType.fromValue(searchType), keyword, novel);
    }

    public static boolean match(SearchType searchType, String keyword, Novel novel) {
        switch (searchType) {
            case NAME: {
                if (CharSequenceUtil.containsIgnoreCase((CharSequence)novel.getTitle(), (CharSequence)keyword)) break;
                return false;
            }
            case AUTHOR: {
                if (!CharSequenceUtil.isNotBlank((CharSequence)novel.getAuthor()) || novel.getAuthor().contains(keyword) || CharSequenceUtil.containsIgnoreCase((CharSequence)novel.getTitle(), (CharSequence)keyword)) break;
                return false;
            }
            case SPEAKER: {
                if (!CharSequenceUtil.isNotBlank((CharSequence)novel.getBroadcast()) || novel.getBroadcast().contains(keyword) || CharSequenceUtil.containsIgnoreCase((CharSequence)novel.getTitle(), (CharSequence)keyword)) break;
                return false;
            }
        }
        return true;
    }

    public String getDesc() {
        return this.desc;
    }
}

