/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.db.dao;

import cn.hutool.core.io.IoUtil;
import com.google.gson.reflect.TypeToken;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.TableUtils;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import com.unclezs.novel.app.main.db.BaseDao;
import com.unclezs.novel.app.main.db.beans.TxtTocRule;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtTocRuleDao
extends BaseDao<TxtTocRule> {
    private static final Logger log = LoggerFactory.getLogger(TxtTocRuleDao.class);
    public static final String PATH = "assets/defaults/toc-rule.json";

    public static void main(String[] args) throws SQLException {
        TxtTocRuleDao dao = new TxtTocRuleDao();
        TableUtils.dropTable((Dao)dao.dao, (boolean)true);
        TableUtils.createTable((Dao)dao.dao);
        dao.importDefault();
    }

    public List<TxtTocRule> importDefault() {
        String defaultRuleJson = IoUtil.readUtf8((InputStream)ResourceUtils.stream((String)PATH));
        List rules = (List)GsonUtils.me().fromJson(defaultRuleJson, new TypeToken<List<TxtTocRule>>(){}.getType());
        try {
            this.dao.deleteIds((Collection)rules.stream().map(TxtTocRule::getId).collect(Collectors.toList()));
            this.dao.create((Collection)rules);
        }
        catch (SQLException e) {
            log.error("\u5bfc\u5165\u9ed8\u8ba4\u7ae0\u8282\u89e3\u6790\u89c4\u5219\u6570\u636e\u5931\u8d25");
            e.printStackTrace();
        }
        return rules;
    }

    public List<TxtTocRule> selectAllByOrder() {
        try {
            return this.dao.queryBuilder().orderBy("order", true).query();
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u5168\u90e8TXT\u76ee\u5f55\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

