/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.db.beans;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@DatabaseTable(tableName="search_engine")
public class SearchEngine
implements Serializable {
    public static final String STYLESHEET_PATH = "css/home/webview/";
    private static final String BAIDU_SEARCH_URL = "https://www.baidu.com/s?wd=title: (\u9605\u8bfb \"{{keyword}}\" (\u6700\u65b0\u7ae0\u8282) -(\u5b98\u65b9\u7f51\u7ad9))";
    private static final String GOOGLE_SEARCH_URL = "https://www.google.com.hk/search?q={{keyword}} \u5c0f\u8bf4\u6700\u65b0\u7ae0\u8282";
    private static final String BY_SEARCH_URL = "https://cn.bing.com/search?q={{keyword}} \u5c0f\u8bf4\u6700\u65b0\u7ae0\u8282";
    @DatabaseField(generatedId=true)
    private int id;
    @DatabaseField
    private Boolean enabled;
    @DatabaseField
    private String name;
    @DatabaseField
    private String url;
    @DatabaseField
    private String stylesheet;

    public SearchEngine() {
        this.enabled = true;
    }

    public SearchEngine(String name, String url, String stylesheet) {
        this();
        this.name = name;
        this.url = url;
        this.stylesheet = stylesheet;
    }

    public static List<SearchEngine> getDefault() {
        ArrayList<SearchEngine> defaults = new ArrayList<SearchEngine>();
        defaults.add(new SearchEngine("\u767e\u5ea6", BAIDU_SEARCH_URL, STYLESHEET_PATH.concat("baidu.css")));
        defaults.add(new SearchEngine("\u8c37\u6b4c", GOOGLE_SEARCH_URL, STYLESHEET_PATH.concat("google.css")));
        defaults.add(new SearchEngine("\u5fc5\u5e94", BY_SEARCH_URL, STYLESHEET_PATH.concat("bing.css")));
        return defaults;
    }

    public String getDomain() {
        return UrlUtils.getHost((String)this.getUrl());
    }

    public int getId() {
        return this.id;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchEngine)) {
            return false;
        }
        SearchEngine other = (SearchEngine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$stylesheet = this.getStylesheet();
        String other$stylesheet = other.getStylesheet();
        return !(this$stylesheet == null ? other$stylesheet != null : !this$stylesheet.equals(other$stylesheet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchEngine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $stylesheet = this.getStylesheet();
        result = result * 59 + ($stylesheet == null ? 43 : $stylesheet.hashCode());
        return result;
    }

    public String toString() {
        return "SearchEngine(id=" + this.getId() + ", enabled=" + this.getEnabled() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", stylesheet=" + this.getStylesheet() + ")";
    }

    public SearchEngine(int id, Boolean enabled, String name, String url, String stylesheet) {
        this.id = id;
        this.enabled = enabled;
        this.name = name;
        this.url = url;
        this.stylesheet = stylesheet;
    }
}

