/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.db.beans;

import cn.hutool.core.date.DateUtil;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.app.main.core.spider.SpiderWrapper;
import java.util.StringJoiner;

@DatabaseTable(tableName="download_history")
public class DownloadHistory {
    public static final int AUDIO = 1;
    public static final int TXT = 2;
    public static final int EPUB = 3;
    public static final int MOBI = 4;
    @DatabaseField(generatedId=true)
    private int id;
    @DatabaseField
    private String name;
    @DatabaseField
    private String path;
    @DatabaseField
    private String date;
    @DatabaseField
    private String type;

    public static DownloadHistory fromWrapper(SpiderWrapper wrapper) {
        DownloadHistory history = new DownloadHistory();
        history.setDate(DateUtil.today());
        history.setName(wrapper.getName());
        history.setPath(wrapper.getSpider().getSavePath());
        AnalyzerRule rule = wrapper.getSpider().getAnalyzerRule();
        if (Boolean.TRUE.equals(rule.getAudio())) {
            history.setType("\u6709\u58f0");
        } else {
            StringJoiner joiner = new StringJoiner(",");
            if (wrapper.isTxt()) {
                joiner.add("TXT");
            }
            if (wrapper.isMobi()) {
                joiner.add("MOBI");
            }
            if (wrapper.isEpub()) {
                joiner.add("EPUB");
            }
            history.setType(joiner.toString());
        }
        return history;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getDate() {
        return this.date;
    }

    public String getType() {
        return this.type;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadHistory)) {
            return false;
        }
        DownloadHistory other = (DownloadHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadHistory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "DownloadHistory(id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", date=" + this.getDate() + ", type=" + this.getType() + ")";
    }
}

