/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.db.beans;

import cn.hutool.core.util.IdUtil;
import com.j256.ormlite.field.DatabaseField;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.app.main.model.BookBundle;
import java.util.List;

public class Book {
    @DatabaseField(id=true)
    protected String id;
    @DatabaseField
    protected String url;
    @DatabaseField
    protected String name;
    @DatabaseField
    protected String author;
    @DatabaseField
    protected String cover;
    @DatabaseField
    protected int order;
    @DatabaseField
    protected int currentChapterIndex;
    protected List<Chapter> toc;
    protected AnalyzerRule rule;
    @DatabaseField
    private String group;
    @DatabaseField
    private int currentPage;
    @DatabaseField
    private String charset;
    @DatabaseField
    private boolean local;
    @DatabaseField
    private String txtTocRule;
    @DatabaseField
    private boolean update;

    public Book(String url, String charset) {
        this.url = url;
        this.charset = charset;
    }

    public static Book fromBookBundle(BookBundle bookBundle) {
        Novel novel = bookBundle.getNovel();
        Book book = new Book();
        book.url = novel.getUrl();
        book.author = novel.getAuthor();
        book.name = novel.getTitle();
        book.cover = novel.getCoverUrl();
        book.toc = novel.getChapters();
        book.rule = bookBundle.getRule();
        book.id = IdUtil.fastSimpleUUID();
        book.currentChapterIndex = 0;
        book.currentPage = 0;
        return book;
    }

    public Novel toNovel() {
        Novel novel = new Novel();
        novel.setUrl(this.url);
        novel.setAuthor(this.author);
        novel.setTitle(this.name);
        novel.setCoverUrl(this.cover);
        novel.setChapters(this.toc);
        return novel;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCover() {
        return this.cover;
    }

    public int getOrder() {
        return this.order;
    }

    public int getCurrentChapterIndex() {
        return this.currentChapterIndex;
    }

    public List<Chapter> getToc() {
        return this.toc;
    }

    public AnalyzerRule getRule() {
        return this.rule;
    }

    public String getGroup() {
        return this.group;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getTxtTocRule() {
        return this.txtTocRule;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setCurrentChapterIndex(int currentChapterIndex) {
        this.currentChapterIndex = currentChapterIndex;
    }

    public void setToc(List<Chapter> toc) {
        this.toc = toc;
    }

    public void setRule(AnalyzerRule rule) {
        this.rule = rule;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setTxtTocRule(String txtTocRule) {
        this.txtTocRule = txtTocRule;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Book)) {
            return false;
        }
        Book other = (Book)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.getCurrentChapterIndex() != other.getCurrentChapterIndex()) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        if (this.isLocal() != other.isLocal()) {
            return false;
        }
        if (this.isUpdate() != other.isUpdate()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$cover = this.getCover();
        String other$cover = other.getCover();
        if (this$cover == null ? other$cover != null : !this$cover.equals(other$cover)) {
            return false;
        }
        List<Chapter> this$toc = this.getToc();
        List<Chapter> other$toc = other.getToc();
        if (this$toc == null ? other$toc != null : !((Object)this$toc).equals(other$toc)) {
            return false;
        }
        AnalyzerRule this$rule = this.getRule();
        AnalyzerRule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$txtTocRule = this.getTxtTocRule();
        String other$txtTocRule = other.getTxtTocRule();
        return !(this$txtTocRule == null ? other$txtTocRule != null : !this$txtTocRule.equals(other$txtTocRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Book;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + this.getCurrentChapterIndex();
        result = result * 59 + this.getCurrentPage();
        result = result * 59 + (this.isLocal() ? 79 : 97);
        result = result * 59 + (this.isUpdate() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $cover = this.getCover();
        result = result * 59 + ($cover == null ? 43 : $cover.hashCode());
        List<Chapter> $toc = this.getToc();
        result = result * 59 + ($toc == null ? 43 : ((Object)$toc).hashCode());
        AnalyzerRule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $txtTocRule = this.getTxtTocRule();
        result = result * 59 + ($txtTocRule == null ? 43 : $txtTocRule.hashCode());
        return result;
    }

    public String toString() {
        return "Book(id=" + this.getId() + ", url=" + this.getUrl() + ", name=" + this.getName() + ", author=" + this.getAuthor() + ", cover=" + this.getCover() + ", order=" + this.getOrder() + ", currentChapterIndex=" + this.getCurrentChapterIndex() + ", toc=" + this.getToc() + ", rule=" + this.getRule() + ", group=" + this.getGroup() + ", currentPage=" + this.getCurrentPage() + ", charset=" + this.getCharset() + ", local=" + this.isLocal() + ", txtTocRule=" + this.getTxtTocRule() + ", update=" + this.isUpdate() + ")";
    }

    public Book() {
    }
}

