/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.db.beans;

import cn.hutool.core.util.IdUtil;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.model.BookBundle;

@DatabaseTable(tableName="audio_book")
public class AudioBook
extends Book {
    @DatabaseField
    private double currentProgress;
    @DatabaseField
    private String broadcast;
    @DatabaseField
    private String currentChapterName;

    public static AudioBook fromBookBundle(BookBundle bookBundle) {
        Novel novel = bookBundle.getNovel();
        AudioBook book = new AudioBook();
        book.url = novel.getUrl();
        book.author = novel.getAuthor();
        book.name = novel.getTitle();
        book.broadcast = novel.getBroadcast();
        book.cover = novel.getCoverUrl();
        book.toc = novel.getChapters();
        book.id = IdUtil.fastSimpleUUID();
        book.currentChapterIndex = 0;
        book.currentChapterName = ((Chapter)book.toc.get(0)).getName();
        book.currentProgress = 0.0;
        book.rule = bookBundle.getRule();
        return book;
    }

    @Override
    public Novel toNovel() {
        Novel novel = new Novel();
        novel.setUrl(this.url);
        novel.setAuthor(this.author);
        novel.setTitle(this.name);
        novel.setBroadcast(this.broadcast);
        novel.setCoverUrl(this.cover);
        novel.setChapters(this.toc);
        return novel;
    }

    public double getCurrentProgress() {
        return this.currentProgress;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public String getCurrentChapterName() {
        return this.currentChapterName;
    }

    public void setCurrentProgress(double currentProgress) {
        this.currentProgress = currentProgress;
    }

    public void setBroadcast(String broadcast) {
        this.broadcast = broadcast;
    }

    public void setCurrentChapterName(String currentChapterName) {
        this.currentChapterName = currentChapterName;
    }

    @Override
    public String toString() {
        return "AudioBook(currentProgress=" + this.getCurrentProgress() + ", broadcast=" + this.getBroadcast() + ", currentChapterName=" + this.getCurrentChapterName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioBook)) {
            return false;
        }
        AudioBook other = (AudioBook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getCurrentProgress(), other.getCurrentProgress()) != 0) {
            return false;
        }
        String this$broadcast = this.getBroadcast();
        String other$broadcast = other.getBroadcast();
        if (this$broadcast == null ? other$broadcast != null : !this$broadcast.equals(other$broadcast)) {
            return false;
        }
        String this$currentChapterName = this.getCurrentChapterName();
        String other$currentChapterName = other.getCurrentChapterName();
        return !(this$currentChapterName == null ? other$currentChapterName != null : !this$currentChapterName.equals(other$currentChapterName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AudioBook;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentProgress = Double.doubleToLongBits(this.getCurrentProgress());
        result = result * 59 + (int)($currentProgress >>> 32 ^ $currentProgress);
        String $broadcast = this.getBroadcast();
        result = result * 59 + ($broadcast == null ? 43 : $broadcast.hashCode());
        String $currentChapterName = this.getCurrentChapterName();
        result = result * 59 + ($currentChapterName == null ? 43 : $currentChapterName.hashCode());
        return result;
    }
}

