/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.db;

import com.j256.ormlite.dao.Dao;
import com.unclezs.novel.app.framework.util.ReflectUtils;
import com.unclezs.novel.app.main.db.beans.DownloadHistory;
import com.unclezs.novel.app.main.exception.DbException;
import com.unclezs.novel.app.main.util.DbHelper;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDao<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseDao.class);
    protected Dao<T, Integer> dao;

    protected BaseDao() {
        Class daoClass = ReflectUtils.getSuperClassGenericType(this.getClass());
        this.dao = DbHelper.getDao(daoClass);
    }

    public void save(T data) {
        try {
            this.dao.create(data);
        }
        catch (SQLException e) {
            log.error("\u4fdd\u5b58\u5931\u8d25\uff1a{}", data, (Object)e);
        }
    }

    public void update(T data) {
        try {
            this.dao.update(data);
        }
        catch (SQLException e) {
            log.error("\u66f4\u65b0\u5931\u8d25\uff1a{}", data, (Object)e);
        }
    }

    public List<T> selectAll() {
        try {
            return this.dao.queryForAll();
        }
        catch (SQLException e) {
            log.error("\u67e5\u8be2\u5168\u90e8\u5931\u8d25", (Throwable)e);
            throw new DbException(e);
        }
    }

    public void delete(T data) {
        try {
            this.dao.delete(data);
        }
        catch (SQLException e) {
            log.error("\u5220\u9664\u5931\u8d25\uff1a{}", data, (Object)e);
        }
    }

    public void clear() {
        try {
            DbHelper.clearTable(DownloadHistory.class);
        }
        catch (SQLException e) {
            log.error("\u6e05\u7a7a\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public void createOrUpdate(T data) {
        try {
            this.dao.createOrUpdate(data);
        }
        catch (SQLException e) {
            log.error("\u65b0\u589e\u6216\u66f4\u65b0\u5931\u8d25\uff1a{}", data, (Object)e);
        }
    }

    public Dao<T, Integer> getDao() {
        return this.dao;
    }
}

