/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.webdav;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.okhttp.OkHttpClient;
import java.io.File;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDav {
    private static final Logger log = LoggerFactory.getLogger(WebDav.class);
    public static final String PROPS = "<a:propfind xmlns:a=\"DAV:\">\n                    <a:prop>\n                        <a:displayname/>\n                        <a:resourcetype/>\n                        <a:getcontentlength/>\n                        <a:creationdate/>\n                        <a:getlastmodified/>\n                    </a:prop>\n                </a:propfind>";
    public static final String DIR = "uncle-novel";
    public static final String AUTHORIZATION = "Authorization";
    private String name;
    private String username;
    private String password;
    private String url;
    private WebDav parent;

    private WebDav() {
    }

    public static WebDav create(String name) {
        return new WebDav().setName(name);
    }

    public static WebDav createDefault() {
        return new WebDav().setName(DIR);
    }

    public WebDav setUrl(String url) {
        this.url = url.endsWith("/") ? url + this.name : url + "/" + this.name;
        return this;
    }

    public WebDav setName(String name) {
        this.name = name;
        return this;
    }

    public WebDav setParent(WebDav webDav) {
        this.parent = webDav;
        return this;
    }

    public WebDav setUsername(String username) {
        this.username = username;
        return this;
    }

    public WebDav setPassword(String password) {
        this.password = password;
        return this;
    }

    public WebDav child(String name) {
        return WebDav.create(name).setUsername(this.username).setPassword(this.password).setUrl(this.url).setParent(this);
    }

    public boolean exist() {
        try {
            RequestParams params = this.createParams("PROPFIND");
            return Http.validate((RequestParams)params);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void mkdir() {
        RequestParams params = this.createParams("MKCOL");
        this.content(params);
    }

    public void upload(File file) {
        if (this.parent != null && !this.parent.exist()) {
            this.parent.mkdir();
        }
        Request request = new Request.Builder().url(this.url).addHeader(AUTHORIZATION, Credentials.basic((String)this.username, (String)this.password)).put(RequestBody.create(null, (File)file)).build();
        OkHttpClient client = (OkHttpClient)Http.getStaticHttpClient();
        ResponseBody body = null;
        Response response = null;
        try {
            response = client.getStaticHttpClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                body = response.body();
                String result = null;
                if (body != null) {
                    result = body.string();
                }
                log.error("WebDav\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:{}\uff1a{}", (Object)this.url, (Object)result);
                throw new IORuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:{}", new Object[]{result});
            }
        }
        catch (IOException e) {
            throw new IORuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (body != null) {
                body.close();
            }
        }
    }

    public void download(File file) {
        if (!this.exist()) {
            return;
        }
        RequestParams params = RequestParams.create((String)this.url);
        params.addHeader(AUTHORIZATION, Credentials.basic((String)this.username, (String)this.password));
        params.addHeader("Depth", "1");
        try {
            byte[] bytes = Http.bytes((RequestParams)params);
            FileUtil.writeBytes((byte[])bytes, (File)file);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}", (Object)this.url, (Object)e);
        }
    }

    private RequestParams createParams(String method) {
        RequestParams params = RequestParams.create((String)this.url);
        params.addHeader(AUTHORIZATION, Credentials.basic((String)this.username, (String)this.password));
        params.addHeader("Depth", "1");
        params.setMethod(method);
        params.setMediaType("text/plain");
        params.setBody(PROPS);
        return params;
    }

    private String content(RequestParams params) {
        try {
            return Http.content((RequestParams)params);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return "WebDav(name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", url=" + this.url + ", parent=" + this.parent + ")";
    }
}

