/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.spider;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import com.unclezs.novel.analyzer.spider.Spider;
import com.unclezs.novel.analyzer.spider.pipline.MediaFilePipeline;
import com.unclezs.novel.analyzer.spider.pipline.Pipeline;
import com.unclezs.novel.analyzer.spider.pipline.TxtPipeline;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.serialize.PropertyJsonSerializer;
import com.unclezs.novel.app.main.core.pipeline.EbookPipeline;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.config.DownloadConfig;
import com.unclezs.novel.app.main.views.home.DownloadManagerView;
import java.io.File;
import java.io.Serializable;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class SpiderWrapper
implements Serializable {
    public static final int WAIT_RUN = 1001;
    private final transient ObjectProperty<Double> progress = new SimpleObjectProperty();
    private final transient ObjectProperty<String> progressText = new SimpleObjectProperty();
    private final transient ObjectProperty<Integer> errorCount = new SimpleObjectProperty();
    private ObjectProperty<Integer> state = new SimpleObjectProperty((Object)1001);
    private Spider spider;
    private boolean volume;
    private boolean mobi;
    private boolean txt;
    private boolean epub;
    private String name;
    private String id;
    private transient File tmpFile;
    private transient Consumer<SpiderWrapper> onSucceed;

    public SpiderWrapper() {
        if (this.id == null) {
            this.id = IdUtil.fastSimpleUUID();
        }
        this.setId(this.id);
    }

    public SpiderWrapper(Spider spider, Consumer<SpiderWrapper> onSucceed) {
        this();
        this.spider = spider;
        this.onSucceed = onSucceed;
        this.init();
        DownloadConfig downloadConfig = SettingManager.manager().getDownload();
        this.epub = Boolean.TRUE.equals(downloadConfig.getEpub().get());
        this.mobi = Boolean.TRUE.equals(downloadConfig.getMobi().get());
        this.txt = Boolean.TRUE.equals(downloadConfig.getTxt().get());
        this.volume = Boolean.TRUE.equals(downloadConfig.getVolume().get());
        this.initSpider();
    }

    public void init() {
        this.progress.set((Object)this.spider.progress());
        this.progressText.set((Object)this.spider.progressText());
        this.errorCount.set((Object)this.spider.errorCount());
        this.name = this.spider.getNovel().getTitle();
        this.spider.setProgressChangeHandler((numberProgress, textProgress) -> {
            this.backup();
            Executor.runFx(() -> {
                this.progress.set(numberProgress);
                this.progressText.set(textProgress);
                this.errorCount.set((Object)this.spider.errorCount());
            });
        });
        this.spider.setOnStateChange(newState -> Executor.runFxAndWait(() -> {
            this.state.set((Object)newState);
            switch (newState) {
                case 7: {
                    this.onSucceed.accept(this);
                    this.checkRunTask();
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    this.checkRunTask();
                    break;
                }
            }
        }));
    }

    private void initSpider() {
        boolean isAudio = Boolean.TRUE.equals(this.spider.getAnalyzerRule().getAudio());
        if (isAudio) {
            this.spider.addPipeline((Pipeline)new MediaFilePipeline());
        } else {
            EbookPipeline pipeline;
            if (this.mobi || this.epub) {
                pipeline = new EbookPipeline();
                pipeline.setEpub(this.epub);
                pipeline.setMobi(this.mobi);
                this.spider.addPipeline((Pipeline)pipeline);
            }
            if (this.txt) {
                pipeline = new TxtPipeline();
                pipeline.setMerge(true);
                pipeline.setDeleteVolume(!this.volume);
                this.spider.addPipeline((Pipeline)pipeline);
            }
        }
    }

    public void init(Consumer<SpiderWrapper> onSucceed) {
        this.onSucceed = onSucceed;
        this.init();
        this.initSpider();
    }

    public boolean isState(int ... expectStates) {
        if (this.state == null) {
            return false;
        }
        for (int expectState : expectStates) {
            if (expectState != (Integer)this.state.get()) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        this.spider.stop();
    }

    public void run() {
        this.spider.runAsync();
    }

    public void runTask() {
        if (((DownloadManagerView)((Object)AppContext.getView(DownloadManagerView.class))).canRunTasksNumber() > 0) {
            this.spider.runAsync();
        } else {
            this.waiting();
        }
    }

    public void retry() {
        this.spider.resetRetryTimes();
        this.runTask();
    }

    public void pause() {
        if (this.spider.isExceed(4)) {
            return;
        }
        this.state.set((Object)3);
        this.spider.pause();
    }

    public void checkRunTask() {
        ((DownloadManagerView)((Object)AppContext.getView(DownloadManagerView.class))).runTask();
    }

    public void waiting() {
        if (this.isState(2)) {
            this.spider.pause();
        }
        this.state.set((Object)1001);
    }

    public void save() {
        this.spider.setIgnoreError(true);
        this.runTask();
    }

    public void setId(String id) {
        this.id = id;
        this.tmpFile = FileUtil.file((File)DownloadManagerView.TMP_DIR, (String)id);
    }

    private void backup() {
        FileUtil.writeUtf8String((String)PropertyJsonSerializer.toJson((Object)this), (File)this.tmpFile);
    }

    public ObjectProperty<Double> getProgress() {
        return this.progress;
    }

    public ObjectProperty<String> getProgressText() {
        return this.progressText;
    }

    public ObjectProperty<Integer> getErrorCount() {
        return this.errorCount;
    }

    public ObjectProperty<Integer> getState() {
        return this.state;
    }

    public Spider getSpider() {
        return this.spider;
    }

    public boolean isVolume() {
        return this.volume;
    }

    public boolean isMobi() {
        return this.mobi;
    }

    public boolean isTxt() {
        return this.txt;
    }

    public boolean isEpub() {
        return this.epub;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public File getTmpFile() {
        return this.tmpFile;
    }

    public Consumer<SpiderWrapper> getOnSucceed() {
        return this.onSucceed;
    }

    public void setState(ObjectProperty<Integer> state) {
        this.state = state;
    }

    public void setSpider(Spider spider) {
        this.spider = spider;
    }

    public void setVolume(boolean volume) {
        this.volume = volume;
    }

    public void setMobi(boolean mobi) {
        this.mobi = mobi;
    }

    public void setTxt(boolean txt) {
        this.txt = txt;
    }

    public void setEpub(boolean epub) {
        this.epub = epub;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTmpFile(File tmpFile) {
        this.tmpFile = tmpFile;
    }

    public void setOnSucceed(Consumer<SpiderWrapper> onSucceed) {
        this.onSucceed = onSucceed;
    }
}

