/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.spi;

import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.spi.HttpProvider;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.executor.Executor;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebEngine;

public class WebEngineHttpClient
implements HttpProvider {
    public static final int MAX_WAIT_TIME = 30;
    public static final String GET_DOM_JS_SCRIPT = "document.documentElement.outerHTML";

    public static void setCookies(RequestParams params) {
        String cookies = params.getHeader("Cookie");
        if (StringUtils.isNotBlank((CharSequence)cookies)) {
            try {
                LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                if (StringUtils.isNotBlank((CharSequence)cookies)) {
                    headers.put("Set-Cookie", Arrays.stream(cookies.split(";")).collect(Collectors.toList()));
                } else {
                    headers.put("Set-Cookie", Collections.emptyList());
                }
                CookieHandler.getDefault().put(URI.create(UrlUtils.getSite((String)params.getUrl())), headers);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String content(final RequestParams params) throws IOException {
        if (!UrlUtils.isHttpUrl((String)params.getUrl())) {
            return "";
        }
        final AtomicReference content = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference<Object> webEngineAtomicReference = new AtomicReference<Object>();
        Executor.runFx(() -> {
            final WebEngine engine = new WebEngine();
            if (StringUtils.isNotBlank((CharSequence)params.getUrl()) || !params.getHeader("User-Agent").equals("Mozilla/5.0 (Macintosh; Intel Mac OS X 11_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36")) {
                engine.setUserAgent(params.getHeader("User-Agent"));
            }
            webEngineAtomicReference.set(engine);
            WebEngineHttpClient.setCookies(params);
            engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observable, Worker.State old, Worker.State newState) {
                    if (newState == Worker.State.SUCCEEDED) {
                        Executor.runFx(() -> {
                            String result = StringUtils.isNotBlank((CharSequence)params.getScript()) ? engine.executeScript(params.getScript()).toString() : engine.executeScript(WebEngineHttpClient.GET_DOM_JS_SCRIPT).toString();
                            engine.loadContent("");
                            content.set(result);
                            countDownLatch.countDown();
                        }, (long)(params.getDynamicDelayTime() == null ? 500L : params.getDynamicDelayTime()));
                        engine.getLoadWorker().stateProperty().removeListener((ChangeListener)this);
                    } else if (newState == Worker.State.CANCELLED || newState == Worker.State.FAILED) {
                        countDownLatch.countDown();
                    }
                }
            });
            engine.load(params.getUrl());
        });
        try {
            boolean success = countDownLatch.await(30L, TimeUnit.SECONDS);
            if (success) {
                String string = (String)content.get();
                return string;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            webEngineAtomicReference.set(null);
        }
        return "";
    }

    public byte[] bytes(RequestParams requestParams) {
        return new byte[0];
    }

    public boolean isDynamic() {
        return true;
    }
}

