/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.pipeline;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.analyzer.core.helper.AnalyzerHelper;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.spider.pipline.AbstractTextPipeline;
import com.unclezs.novel.app.main.util.EbookUtils;
import java.io.File;

public class EbookPipeline
extends AbstractTextPipeline {
    private boolean mobi;
    private boolean epub;

    public void process(Chapter chapter) {
        chapter.setContent(AnalyzerHelper.formatContent((String)chapter.getContent()));
        EbookUtils.generateChapter(chapter, new File(this.getFilePath()));
    }

    public void processChapter(Chapter chapter) {
    }

    public void onComplete() {
        if (this.mobi || this.epub) {
            File outDir = new File(this.getFilePath());
            File tmpFile = EbookUtils.toEbook(this.getNovel(), outDir, false);
            if (this.epub) {
                EbookUtils.toEpub(outDir);
            }
            if (this.mobi) {
                EbookUtils.toMobi(outDir);
            }
            FileUtil.del((File)tmpFile);
        }
    }

    public void setMobi(boolean mobi) {
        this.mobi = mobi;
    }

    public void setEpub(boolean epub) {
        this.epub = epub;
    }
}

