/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.loader;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.lang.PatternPool;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.app.main.core.loader.AbstractBookLoader;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.db.beans.TxtTocRule;
import com.unclezs.novel.app.main.util.EncodingDetect;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtLoader
extends AbstractBookLoader {
    private static final Logger log = LoggerFactory.getLogger(TxtLoader.class);
    private static final int BUFFER_SIZE = 524288;
    private static final int MAX_LENGTH_WITH_NO_CHAPTER = 10240;
    private File bookFile;
    private String charset;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int checkChapterType(File file, List<TxtTocRule> rules) {
        try (RandomAccessFile ras = FileUtil.createRandomAccessFile((File)file, (FileMode)FileMode.r);){
            byte[] buffer = new byte[131072];
            int length = ras.read(buffer, 0, buffer.length);
            int index = 0;
            Iterator<TxtTocRule> iterator = rules.iterator();
            while (iterator.hasNext()) {
                TxtTocRule rule = iterator.next();
                Pattern pattern = PatternPool.get((String)rule.getRule(), (int)8);
                Matcher matcher = pattern.matcher(new String(buffer, 0, length, EncodingDetect.getEncode(file)));
                if (matcher.find()) {
                    ras.seek(0L);
                    int n = index;
                    return n;
                }
                ++index;
            }
            return -1;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790TXT\u76ee\u5f55\u5931\u8d25", (Throwable)e);
        }
        return -1;
    }

    @Override
    public void setBook(Book book) {
        super.setBook(book);
        this.bookFile = new File(this.getBook().getUrl());
        this.charset = this.getBook().getCharset();
        if (this.charset == null) {
            this.charset = EncodingDetect.getEncode(this.bookFile);
        }
    }

    @Override
    public List<Chapter> toc() {
        if (CollectionUtils.isEmpty((Collection)this.toc)) {
            try {
                this.toc = this.loadChapters(PatternPool.get((String)this.book.getTxtTocRule(), (int)8));
            }
            catch (IOException e) {
                log.error("\u672c\u5730\u5c0f\u8bf4\u7ae0\u8282\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)this.bookFile, (Object)e);
                e.printStackTrace();
            }
        }
        return this.toc;
    }

    @Override
    public String loadContent(int index) {
        String string;
        block8: {
            Chapter chapter = this.toc().get(index);
            RandomAccessFile ras = FileUtil.createRandomAccessFile((File)this.bookFile, (FileMode)FileMode.r);
            try {
                ras.seek(chapter.getFrom());
                byte[] bytes = new byte[(int)(chapter.getTo() - chapter.getFrom())];
                ras.read(bytes);
                String content = new String(bytes, this.charset);
                string = content.trim();
                if (ras == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ras != null) {
                        try {
                            ras.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                    return null;
                }
            }
            ras.close();
        }
        return string;
    }

    @Override
    public boolean isCached(int index) {
        return true;
    }

    public boolean checkHasChapter(RandomAccessFile bookStream, Pattern pattern) throws IOException {
        byte[] buffer = new byte[131072];
        int length = bookStream.read(buffer, 0, buffer.length);
        Matcher matcher = pattern.matcher(new String(buffer, 0, length, this.charset));
        if (matcher.find()) {
            bookStream.seek(0L);
            return true;
        }
        bookStream.seek(0L);
        return false;
    }

    public List<Chapter> loadChapters(Pattern pattern) throws IOException {
        int length;
        ArrayList<Chapter> toc = new ArrayList<Chapter>();
        RandomAccessFile bookStream = FileUtil.createRandomAccessFile((File)this.bookFile, (FileMode)FileMode.r);
        boolean hasChapter = this.checkHasChapter(bookStream, pattern);
        byte[] buffer = new byte[524288];
        long curOffset = 0L;
        int blockPos = 0;
        int allLength = 0;
        while ((length = bookStream.read(buffer, 0, buffer.length)) > 0) {
            ++blockPos;
            if (hasChapter) {
                String blockContent = new String(buffer, 0, length, this.charset);
                int lastN = blockContent.lastIndexOf("\n");
                if (lastN != 0) {
                    blockContent = blockContent.substring(0, lastN);
                    length = blockContent.getBytes(this.charset).length;
                    bookStream.seek(allLength += length);
                }
                int seekPos = 0;
                Matcher matcher = pattern.matcher(blockContent);
                while (matcher.find()) {
                    Chapter curChapter;
                    Chapter lastChapter;
                    String chapterContent;
                    int chapterStart = matcher.start();
                    if (seekPos == 0 && chapterStart != 0) {
                        chapterContent = blockContent.substring(seekPos, chapterStart);
                        seekPos += chapterContent.length();
                        if (toc.isEmpty()) {
                            Chapter chapter = new Chapter();
                            chapter.setName(matcher.group());
                            chapter.setFrom(Long.valueOf(chapterContent.getBytes(this.charset).length));
                            toc.add(chapter);
                            continue;
                        }
                        lastChapter = (Chapter)toc.get(toc.size() - 1);
                        lastChapter.setTo(Long.valueOf(lastChapter.getTo() + (long)chapterContent.getBytes(this.charset).length));
                        lastChapter.setFrom(Long.valueOf(lastChapter.getFrom() + (long)lastChapter.getName().getBytes(this.charset).length));
                        curChapter = new Chapter();
                        curChapter.setName(matcher.group());
                        curChapter.setFrom(lastChapter.getTo());
                        toc.add(curChapter);
                        continue;
                    }
                    if (!toc.isEmpty()) {
                        chapterContent = blockContent.substring(seekPos, matcher.start());
                        seekPos += chapterContent.length();
                        lastChapter = (Chapter)toc.get(toc.size() - 1);
                        lastChapter.setTo(Long.valueOf(lastChapter.getFrom() + (long)chapterContent.getBytes(this.charset).length));
                        lastChapter.setFrom(Long.valueOf(lastChapter.getFrom() + (long)lastChapter.getName().getBytes(this.charset).length));
                        curChapter = new Chapter();
                        curChapter.setName(matcher.group());
                        curChapter.setFrom(lastChapter.getTo());
                        toc.add(curChapter);
                        continue;
                    }
                    Chapter curChapter2 = new Chapter();
                    curChapter2.setName(matcher.group());
                    curChapter2.setFrom(Long.valueOf(0L));
                    curChapter2.setTo(Long.valueOf(0L));
                    toc.add(curChapter2);
                }
            } else {
                int chapterOffset = 0;
                int strLength = length;
                int chapterPos = 0;
                while (strLength > 0) {
                    ++chapterPos;
                    if (strLength > 10240) {
                        int end = length;
                        for (int i = chapterOffset + 10240; i < length; ++i) {
                            if (buffer[i] != 10) continue;
                            end = i;
                            break;
                        }
                        Chapter chapter = new Chapter();
                        chapter.setName("\u7b2c" + blockPos + "\u7ae0(" + chapterPos + ")");
                        chapter.setFrom(Long.valueOf(curOffset + (long)chapterOffset + 1L));
                        chapter.setTo(Long.valueOf(curOffset + (long)end));
                        toc.add(chapter);
                        strLength -= end - chapterOffset;
                        chapterOffset = end;
                        continue;
                    }
                    Chapter chapter = new Chapter();
                    chapter.setName("\u7b2c" + blockPos + "\u7ae0(" + chapterPos + ")");
                    chapter.setFrom(Long.valueOf(curOffset + (long)chapterOffset + 1L));
                    chapter.setTo(Long.valueOf(curOffset + (long)length));
                    toc.add(chapter);
                    strLength = 0;
                }
            }
            curOffset += (long)length;
            if (hasChapter) {
                Chapter lastChapter = (Chapter)toc.get(toc.size() - 1);
                lastChapter.setTo(Long.valueOf(curOffset));
            }
            if (blockPos % 15 != 0) continue;
            System.gc();
            System.runFinalization();
        }
        for (int i = 0; i < toc.size(); ++i) {
            Chapter bean = (Chapter)toc.get(i);
            bean.setOrder(i);
        }
        IoUtil.close((Closeable)bookStream);
        System.gc();
        System.runFinalization();
        return toc;
    }
}

