/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.loader;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.main.core.loader.AbstractBookLoader;
import com.unclezs.novel.app.main.views.home.FictionBookshelfView;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookLoader
extends AbstractBookLoader {
    private static final Logger log = LoggerFactory.getLogger(BookLoader.class);
    private final BitSet running = new BitSet();

    @Override
    public String loadContent(int index) {
        File cache = FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String[])new String[]{this.book.getId(), String.valueOf(index)});
        String content = cache.exists() ? FileUtil.readUtf8String((File)cache) : this.load(index);
        if (!this.isCached(index + 1)) {
            this.preloading(index + 1);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String load(int index) {
        if (this.running.get(index) && this.isCached(index)) {
            return null;
        }
        this.running.set(index);
        Chapter chapter = this.toc().get(index);
        File cache = FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String[])new String[]{this.book.getId(), String.valueOf(index)});
        try {
            NovelSpider spider = new NovelSpider(this.rule);
            String content = spider.content(chapter.getUrl());
            if (!this.isCached(index)) {
                FileUtil.writeUtf8String((String)content, (File)cache);
            }
            String string = content;
            return string;
        }
        catch (IOException e) {
            log.error("\u6b63\u6587\u52a0\u8f7d\u5931\u8d25\uff1a{}", (Object)chapter, (Object)e);
        }
        finally {
            this.running.clear(index);
        }
        return null;
    }

    public void preloading(int index) {
        Executor.run(() -> {
            for (int i = index; i < index + 10 && i < this.toc().size() && !this.isCached(i); ++i) {
                this.load(i);
            }
        });
    }
}

