/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core.loader;

import cn.hutool.core.io.FileUtil;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.model.BookCache;
import com.unclezs.novel.app.main.util.BookHelper;
import com.unclezs.novel.app.main.views.home.FictionBookshelfView;
import java.io.File;
import java.util.List;

public abstract class AbstractBookLoader {
    protected Book book;
    protected List<Chapter> toc;
    protected AnalyzerRule rule;

    public void setBook(Book book) {
        this.book = book;
        BookCache cache = BookHelper.loadCache(FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String)book.getId()));
        this.toc = cache.getToc();
        this.rule = cache.getRule();
    }

    public List<Chapter> toc() {
        return this.toc;
    }

    public String content(int index) {
        if (index >= 0 && index < this.toc().size()) {
            return this.loadContent(index);
        }
        return null;
    }

    public abstract String loadContent(int var1);

    public boolean isCached(int index) {
        return index < this.toc.size() && FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String[])new String[]{this.book.getId(), String.valueOf(index)}).exists();
    }

    public Book getBook() {
        return this.book;
    }
}

